#include "f801w_net_camera.h"

#include <iostream>

namespace sl
{

CameraInfo F801WNetCamera::getNetCameraAllInfo()
{
    getSupportFuncInfo();
    getRangeInfo();
    getControlInfo();
    getExposureInfo();
    getWbInfo();
    getFlipMirrorStatus();
    getSystemBaseInfo();
    getIpv4Info();
    getWirelessIpv4Info();
    return m_cameraInfo;
}

void F801WNetCamera::getRangeInfo()
{
    m_cameraInfo.exposure.bright.m_max = 100;
    m_cameraInfo.exposure.bright.m_min = 0;
    m_cameraInfo.exposure.bright.m_def = 50;

    m_cameraInfo.exposure.time.m_def = 0;
    m_cameraInfo.exposure.time.m_max = 333;
    m_cameraInfo.exposure.time.m_min = 0;

    m_cameraInfo.exposure.gain.m_def = 0;
    m_cameraInfo.exposure.gain.m_max = 33;
    m_cameraInfo.exposure.gain.m_min = 0;

    m_cameraInfo.whiteBalance.red.m_def = 608;
    m_cameraInfo.whiteBalance.red.m_max = 4095;
    m_cameraInfo.whiteBalance.red.m_min = 1;
    m_cameraInfo.whiteBalance.red.m_res = 1;

    m_cameraInfo.whiteBalance.green.m_def = 269;
    m_cameraInfo.whiteBalance.green.m_max = 4095;
    m_cameraInfo.whiteBalance.green.m_min = 1;
    m_cameraInfo.whiteBalance.green.m_res = 1;

    m_cameraInfo.whiteBalance.blue.m_def = 395;
    m_cameraInfo.whiteBalance.blue.m_max = 4095;
    m_cameraInfo.whiteBalance.blue.m_min = 1;
    m_cameraInfo.whiteBalance.blue.m_res = 1;

    m_cameraInfo.hue.m_def = 50;
    m_cameraInfo.hue.m_max = 100;
    m_cameraInfo.hue.m_min = 0;
    m_cameraInfo.hue.m_res = 1;

    m_cameraInfo.saturation.m_def = 50;
    m_cameraInfo.saturation.m_max = 100;
    m_cameraInfo.saturation.m_min = 0;
    m_cameraInfo.saturation.m_res = 1;

    m_cameraInfo.contrast.m_def = 50;
    m_cameraInfo.contrast.m_max = 100;
    m_cameraInfo.contrast.m_min = 0;
    m_cameraInfo.contrast.m_res = 1;
}

void F801WNetCamera::getControlInfo()
{
    nlohmann::json imgRecJson = getControlInfoJson();
    if (imgRecJson.is_null())
        return;

    try
    {
        m_cameraInfo.exposure.bright.m_cur =
            imgRecJson.at("image").at("bright").get<int>();
        m_cameraInfo.contrast.m_cur =
            imgRecJson.at("image").at("contrast").get<int>();
        m_cameraInfo.saturation.m_cur =
            imgRecJson.at("image").at("saturation").get<int>();
        m_cameraInfo.monochrome = (m_cameraInfo.saturation.m_cur == 0);
        m_cameraInfo.hue.m_cur = imgRecJson.at("image").at("hue").get<int>();

        if (m_cameraInfo.zoom.m_cur > m_cameraInfo.zoom.m_max)
        {
            m_cameraInfo.dzoom.m_cur =
                m_cameraInfo.zoom.m_cur - m_cameraInfo.zoom.m_max;
            m_cameraInfo.zoom.m_cur = m_cameraInfo.zoom.m_max;
        }
    }
    catch (const nlohmann::detail::exception &e)
    {
        std::cerr << "getControlInfo failed, json throw an error:" << e.what()
                  << std::endl;
    }
}

nlohmann::json F801WNetCamera::getControlInfoJson()
{
    nlohmann::json request = {
        {"cmd", "image"}, {"image", {{"chnn", m_chnn}, {"idx", m_idx}}}};
    return getRequest(request);
}

}  // namespace sl
