#ifndef SL_NEW_NET_CAMERA_H_
#define SL_NEW_NET_CAMERA_H_

#include "net_camera.h"

struct ImageBoolSettings {
    bool flip = false;
    bool mirror = false;
    bool cac = false;
    bool flick = false;
    bool monochrome = false;
    // 以下字段为新增
    bool sharpnessEnhancement = false;
};

struct ImageValueSettings
{
    int contrast = 0;
    int saturation = 0;
    int hue = 0;
    int sharpness = 0;
    int gamma = 0;
    int drc = 0;
    // 以下字段为新增
    int contrastEnhancement = 0;
};

namespace sl
{
class NewNetCamera : public NetCamera
{
public:
    NewNetCamera() = default;
    virtual ~NewNetCamera() = default;

    virtual CameraInfo getNetCameraAllInfo();
    virtual bool setFocus(FocusMode mode, int value, int speed = 3) override;
    virtual bool setFocusRegion(
        bool enable, int x, int y, int mode = 0) override;
    virtual bool setFocusRegionV2(
        bool enable, int x, int y, int width, int height) override;
    virtual bool getFocusRegionV2(
        bool &enable, int &x, int &y, int &width, int &height) override;
    virtual bool getFocusState(bool &focusing) override;
    virtual bool focusAdd() override;
    virtual bool focusSub() override;

    virtual bool setExposure(
        ExposureMode mode, int compensation, int gain,
        int shutterTime) override;
    virtual bool setWb(WbMode mode, int red, int green, int blue) override;
    virtual bool setWbTemperature(int temperature) override;
    virtual bool setZoom(
        int ezoomValue, int dzoomValue, int speed,
        ZoomMode mode = ZoomMode::ZoomAbsolute) override;
    virtual bool setFlip(bool enable) override;
    virtual bool setMirror(bool enable) override;
    virtual bool setCAC(bool enable) override;
    virtual bool setPowerLineFrequency(bool enable) override;
    virtual bool setMonochrome(bool enable) override;
    virtual bool setLed(int partIndex, int level) override;

    virtual bool setContrastValue(int value) override;
    virtual bool setSaturationValue(int value) override;
    virtual bool setHueValue(int value) override;
    virtual bool setSharpnessValue(int value) override;
    virtual bool setGammaValue(int value) override;
    virtual bool setDRCValue(int value) override;
    virtual bool setDefog(bool enable) override;
    virtual bool setScene(int mode);

    virtual bool setSharpnessEnhancement(bool enable);
    virtual bool setContrastEnhancementValue(int value);

    virtual bool getPicStream() override;

protected:
    // 控制接口
    // bright 亮度
    // contrast 对比度
    // saturation 饱和度
    // hue 色度
    // sharpness 锐度
    // gamma 伽马值
    // drc 动态范围压缩/消反光
    // contrastEnhancement 对比度增强
    bool setImageValue(const ImageValueSettings &settings);
    // flip 垂直翻转
    // mirror 镜像翻转
    // 抗频闪 flick true-50hz，false-60hz
    // cac 消紫边
    // monochrome 黑白模式
    // sharpnessEnhancement 锐度增强
    bool setImageBool(const ImageBoolSettings &settings);

    // 新版调节亮度值接口，值为-1时关闭, 在范围内时启用
    bool setLeds(int up, int left, int right, int down);
    // 设置相对聚焦
    // relative - 1-增加1点聚焦值，-1-减少一点聚焦值
    bool setFocusRelative(int relative);

    ImageBoolSettings collectImageBoolSettings() const;
    ImageValueSettings collectImageValueSettings() const;

    // 以下接口用于json转化, 并将参数保存至m_cameraInfo中
    void getImageValueInfo();
    void getImageBoolInfo();
    void getExposureInfo();
    void getWbInfo();
    void getFocusInfo();
    void getFocusRegionInfo();
    void getFocusRegionInfoV2();
    void getZoomInfo();
    void getLedInfo();
    virtual void getIpv4Info() override;
    virtual void getWirelessInfo() override;
    virtual void getWirelessIpv4Info() override;
    virtual void getDefogStatus() override;
    virtual void getSceneInfo() override;

    // 用于获取范围
    void getStreamAbility();
    void getPicAbility();
    void getImageAbility();
    void getMotorAbility();
    void getLedAbility();

protected:
    // 图像相关信息
    virtual nlohmann::json getImageValueInfoJson();
    virtual nlohmann::json getImageBoolInfoJson();
    // 曝光相关信息 曝光模式 快门值 增益 目标亮度
    virtual nlohmann::json getExposureInfoJson() override;
    // 白平衡 模式 红绿蓝值
    virtual nlohmann::json getWbInfoJson() override;
    // 聚焦相关信息
    virtual nlohmann::json getFocusInfoJson();
    // 聚焦区域相关信息
    virtual nlohmann::json getFocusRegionInfoJson() override;
    virtual nlohmann::json getFocusRegionInfoJsonV2();
    // 变倍相关信息
    virtual nlohmann::json getZoomInfoJson();
    // 补光灯相关信息
    virtual nlohmann::json getLedInfoJson();
    virtual nlohmann::json getIpv4InfoJson() override;
    virtual nlohmann::json getWirelessInfoJson() override;
    virtual nlohmann::json getWirelessIpv4InfoJson() override;
    virtual nlohmann::json getDefogStatusJson() override;
    virtual nlohmann::json getSceneInfoJson() override;

    virtual nlohmann::json getStreamJson() override;
    // 拉流相关能力集
    virtual nlohmann::json getStreamAbilityJson();
    // 图片流相关能力集
    virtual nlohmann::json getPicAbilityJson();
    // 图像相关能力集
    virtual nlohmann::json getImageAbilityJson();
    // 电机相关能力集
    virtual nlohmann::json getMotorAbilityJson();
    // 补光灯相关能力集
    virtual nlohmann::json getLedAbilityJson();
};

}  // namespace sl

#endif  // SL_NEW_NET_CAMERA_H_
