using System;
using Newtonsoft.Json.Linq;

namespace netsdkdemo
{
    public class F801WNetCamera : SLcamNet.NetCamera
    {
        public override void GetRangeInfo()
        {
            m_cameraInfo.Exposure.Bright.Max = 100;
            m_cameraInfo.Exposure.Bright.Min = 0;
            m_cameraInfo.Exposure.Bright.Def = 50;

            m_cameraInfo.Exposure.Time.Def = 0;
            m_cameraInfo.Exposure.Time.Max = 333;
            m_cameraInfo.Exposure.Time.Min = 0;

            m_cameraInfo.Exposure.Gain.Def = 0;
            m_cameraInfo.Exposure.Gain.Max = 33;
            m_cameraInfo.Exposure.Gain.Min = 0;

            m_cameraInfo.WhiteBalance.Red.Def = 628;
            m_cameraInfo.WhiteBalance.Red.Max = 4095;
            m_cameraInfo.WhiteBalance.Red.Min = 1;
            m_cameraInfo.WhiteBalance.Red.Res = 1;

            m_cameraInfo.WhiteBalance.Green.Def = 256;
            m_cameraInfo.WhiteBalance.Green.Max = 4095;
            m_cameraInfo.WhiteBalance.Green.Min = 1;
            m_cameraInfo.WhiteBalance.Green.Res = 1;

            m_cameraInfo.WhiteBalance.Blue.Def = 421;
            m_cameraInfo.WhiteBalance.Blue.Max = 4095;
            m_cameraInfo.WhiteBalance.Blue.Min = 1;
            m_cameraInfo.WhiteBalance.Blue.Res = 1;

            m_cameraInfo.Hue.Def = 50;
            m_cameraInfo.Hue.Max = 100;
            m_cameraInfo.Hue.Min = 0;
            m_cameraInfo.Hue.Res = 1;

            m_cameraInfo.Saturation.Def = 50;
            m_cameraInfo.Saturation.Max = 100;
            m_cameraInfo.Saturation.Min = 0;
            m_cameraInfo.Saturation.Res = 1;

            m_cameraInfo.Contrast.Def = 50;
            m_cameraInfo.Contrast.Max = 100;
            m_cameraInfo.Contrast.Min = 0;
            m_cameraInfo.Contrast.Res = 1;
        }

        public override CameraInfo GetNetCameraAllInfo()
        {
            GetRangeInfo();
            GetOldControlInfo();
            GetExposureInfo();
            GetWbInfo();
            GetFlipMirrorStatus();
            GetSystemBaseInfo();
            GetIpv4Info();
            getStreamInfo();
            // SetFlipMirror(true, false);
            // SetIpv4(false,ip,)
            return m_cameraInfo;
        }

        private void getStreamInfo()
        {
            /*{
                "stream": {
                    "bitrate": 20000,
                    "i_interval": 90,
                    "quality": "high",
                    "frame_rate": 25,
                    "code": 0,
                    "rc_mode": "cbr",
                    "fmt": "h264",
                    "range": {
                        "fmt": [
                        "h264"
                            ],
                        "rc_mode": [
                        "vbr",
                        "cbr"
                            ],
                        "bitrate": {
                            "min": 2,
                            "max": 24576
                        },
                        "i_interval": {
                            "min": 25,
                            "max": 90
                        },
                        "wh": [
                        "1920*1080",
                        "1280*720",
                        "960*540"
                            ],
                        "quality": [
                        "highest",
                        "higher",
                        "high",
                        "middle",
                        "low",
                        "lower",
                        "lowest"
                            ],
                        "frame_rate": {
                            "min": 1,
                            "max": 25
                        }
                    },
                    "wh": "1920*1080",
                    "chnn": 0,
                    "idx": 0
                },
                "cmd": "stream"
            }*/
            var streamInfoJson = getStreamInfoJson();
        }

        private void GetOldControlInfo()
        {
            JObject imgRecJson = GetOldControlInfoJson();
            if (imgRecJson == null)
                return;

            try
            {
                imgRecJson["image"]["bright"].ToObject<int>();
                m_cameraInfo.Contrast.Cur =
                    imgRecJson["image"]["contrast"].ToObject<int>();
                m_cameraInfo.Saturation.Cur =
                    imgRecJson["image"]["saturation"].ToObject<int>();
                m_cameraInfo.Monochrome = m_cameraInfo.Saturation.Cur == 0;
                m_cameraInfo.Hue.Cur =
                    imgRecJson["image"]["hue"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetExposureInfo()
        {
            var exposureRecJson = GetExposureInfoJson();
            if (exposureRecJson == null)
                return;
            var imgRecJson = GetOldControlInfoJson();
            if (imgRecJson == null)
                return;
            try
            {
                m_cameraInfo.Exposure.Bright.Cur =
                    imgRecJson["image"]["bright"].ToObject<int>();
                int mode = exposureRecJson["img_meexposure"]["expo_type"].ToObject<int>();
                m_cameraInfo.Exposure.Mode = ConvertFromNetExposureMode(mode);
                m_cameraInfo.Exposure.Time.Cur =
                    exposureRecJson["img_meexposure"]["shuttertime"].ToObject<int>();
                m_cameraInfo.Exposure.Gain.Cur =
                    exposureRecJson["img_meexposure"]["a_gain"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }
    }
}