﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using csharpdemo;

namespace netsdkdemo
{
    public partial class Form1 : Form
    {
        private SLcamNet.NetCamera _camera;

        // private SDL2. _sdlEvent;
        private IntPtr _window = IntPtr.Zero;
        private IntPtr _renderer = IntPtr.Zero;
        private IntPtr _texture = IntPtr.Zero;
        private SDL2.SDL_Rect _rect;
        private const int kStreamDecID = 100;
        private List<NetInfo> _infos;
        private SDLPanel sdlPanel;
        private Task _task;
        private bool _running;
        private CameraInfo _cameraInfo;
        private bool _captureImage;

        public Form1()
        {
            InitializeComponent();
            SLcamNet.NetCamera.InitNet();
            // InitNet();
        }

        private void scan_btn_Click(object sender, EventArgs e)
        {
            SLcamNet.l_md_data_t frameData = new SLcamNet.l_md_data_t();
            frameData.ToString();
            _infos = SLcamNet.NetCamera.SearchAvailableCameras();
            if (_infos.Count <= 0)
                return;

            devList_cBox.Items.Clear();
            for (int i = 0; i < _infos.Count; ++i)
            {
                devList_cBox.Items.Add(_infos[i].Ip);
                SLcamNet.NetCamera.LOG(
                    $"Camera {i}, IP={_infos[i].Ip}, model={_infos[i].Model},version={_infos[i].Version}");
            }

            devList_cBox.SelectedIndex = 0;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            // 停止取流
            _running = false;
            //_task?.Wait();
            _task = null;

            // 释放摄像机资源
            _camera?.Close();
            _camera?.Logout();
            SLcamNet.NetCamera.DestroyNet();

            // 释放 SDLPanel 资源
            sdlPanel?.Dispose(true);
            sdlPanel = null;
        }

        private void open_btn_Click(object sender, EventArgs e)
        {
            // sdlPanel?.Dispose(true);
            // sdlPanel = new SDLPanel();
            sdlPanel?.Dispose(true);
            sdlPanel = new SDLPanel();

            resolu_cBox.Items.Clear();
            sdlPanel.Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;


            // 组装camsettings  A3xx系列的这些信息可以从streamAbilityJson中进行获取能力集  其他系列需要参考对应的使用说明书自行组装
            CameraSettings settings = new CameraSettings
            {
                netInfo = _infos[devList_cBox.SelectedIndex],

                Resolution = new CameraResolution(1920, 1080),
                // WIFI相机仅支持h264格式，分辨率仅支持1920x1080，码率最高为30000
                StreamFormat = StreamFormat.kMJPEG, // F801w 仅支持h264
                PixFormat = PixFormat.kYUV420P,
                RcMode = "cbr",
                Quality = "high",
                FrameRate = 25,
                Bitrate = 86000,
                KeyFrameInterval = 90
            };
            settings.netInfo.Username = "admin";
            settings.netInfo.Password = "123456";


            _camera = SLcamNet.NetCamera.Create(settings.netInfo.Model, settings.netInfo.Version);
            _camera.SetCameraSettings(settings);
            _camera.Login();
            _cameraInfo = _camera.GetNetCameraAllInfo();
            _camera.Open();

            // 多相机实例时需要设置不同的解码id，否则会出现多个相机视频流相同的情况
            // _camera2 = SLcamNet.NetCamera.Create(settings.netInfo.Model);
            // _camera2.SetStreamDecID(101);
            // _camera2.SetCameraSettings(settings);
            // _camera2.Login();
            // _camera2Info = _camera.GetNetCameraAllInfo();
            // _camera2.Open();

            // _camera.getStreamInfoJson();
            // 以C314为例  A系列可从get_stream_ability中的wh中获得受支持的分辨率集合  F801W 可从getStreamInfoJson中获取对应的能力集
            resolu_cBox.Items.Add("1920*1080");
            // resolu_cBox.Items.Add("1280*720");
            // resolu_cBox.Items.Add("2592*1944");
            // resolu_cBox.Items.Add("3840*2160");
            // resolu_cBox.Items.Add("4000*3000");

            resolu_cBox.SelectedIndex = 0;
            _running = true;
            device_info();
            _task = Task.Run(() => StartCameraCapture(0));
        }

        private void device_info()
        {
            // _camera.GetControlInfo();

            // focus
            if (_cameraInfo.Focus.Mode == FocusMode.kFocusAuto)
            {
                autoFocus_checkBox.Checked = true;
                focus_tBar.Enabled = false;
                focus_tBar.SetRange(_cameraInfo.Focus.Value.Min, _cameraInfo.Focus.Value.Max);
            }
            else if (_cameraInfo.Focus.Mode == FocusMode.kFocusManual)
            {
                autoFocus_checkBox.Checked = false;
                focus_tBar.Enabled = true;
                // M系列的focus range可能存在问题，且只能使用加减聚焦接口FocusAdd FocusSub接口
                focus_tBar.SetRange(_cameraInfo.Focus.Value.Min, _cameraInfo.Focus.Value.Max);
                // 非A系列相机显示时需要加上25  发送时需减去25（在setFocus中已提供和获取Focus值中均已设置）
                focus_tBar.Value = _cameraInfo.Focus.Value.Cur;

                focus_lab.Text = focus_tBar.Value.ToString();
            }

            // 不存在聚焦
            if (_cameraInfo.Focus.Value.Max == 0)
            {
                focus_tBar.Enabled = false;
                autoFocus_checkBox.Enabled = false;
                focus_lab.Enabled = false;
            }

            // 曝光
            autoExp_checkBox.Checked = _cameraInfo.Exposure.Mode == ExposureMode.kExpAuto;

            // 白平衡
            autoWB_checkBoz.Checked = _cameraInfo.WhiteBalance.Mode == WbMode.kWBAuto;
            if (!autoWB_checkBoz.Checked)
            {
                // 手动时
                red_tBar.Enabled = green_tBar.Enabled = blue_tBar.Enabled = true;
                red_tBar.SetRange(_cameraInfo.WhiteBalance.Red.Min, _cameraInfo.WhiteBalance.Red.Max);
                green_tBar.SetRange(_cameraInfo.WhiteBalance.Green.Min, _cameraInfo.WhiteBalance.Green.Max);
                blue_tBar.SetRange(_cameraInfo.WhiteBalance.Blue.Min, _cameraInfo.WhiteBalance.Blue.Max);
                red_tBar.Value = _cameraInfo.WhiteBalance.Red.Cur;
                green_tBar.Value = _cameraInfo.WhiteBalance.Green.Cur;
                blue_tBar.Value = _cameraInfo.WhiteBalance.Blue.Cur;
            }
            else
            {
                red_tBar.Enabled = green_tBar.Enabled = blue_tBar.Enabled = false;
                red_tBar.SetRange(_cameraInfo.WhiteBalance.Red.Min, _cameraInfo.WhiteBalance.Red.Max);
                green_tBar.SetRange(_cameraInfo.WhiteBalance.Green.Min, _cameraInfo.WhiteBalance.Green.Max);
                blue_tBar.SetRange(_cameraInfo.WhiteBalance.Blue.Min, _cameraInfo.WhiteBalance.Blue.Max);
            }
        }

        private void close_btn_Click(object sender, EventArgs e)
        {
            _running = false;
            _task = null;
            if (sdlPanel != null)
            {
                this.panel1.Controls.Remove(sdlPanel);
                sdlPanel?.Dispose(true);
                sdlPanel = null;
            }

            _camera?.Close();
        }

        private void StartCameraCapture(int mCurrentCam)
        {
            var stopwatch = new Stopwatch();
            int frameCount = 0;
            stopwatch.Start();

            // 设置完参数后  需要等待一段时间后取流（否则可能会取流失败问题）
            // System.Threading.Thread.Sleep(500);

            IntPtr frameDataPtr = IntPtr.Zero;
            while (_running)
            {
                // if (!_slcam.ReadFrame(ref vframe)) continue;
                if (!_camera.GetVideoFrameData(ref frameDataPtr)) continue;

                SLcamNet.l_md_data_t frameData = SLcamNet.l_md_data_t.FromIntPtr(frameDataPtr);

                frameCount++;

                if (stopwatch.ElapsedMilliseconds >= 3000)
                {
                    var fps = (double)(frameCount / (stopwatch.ElapsedMilliseconds / 1000.0));
                    Invoke((MethodInvoker)(() => { fps_lab.Text = fps.ToString("0.00"); }));

                    // 重置计时器和计数器
                    stopwatch.Restart();
                    frameCount = 0;
                }

                try
                {
                    this?.Invoke((MethodInvoker)(() =>
                    {
                        if (sdlPanel != null && !sdlPanel.IsDisposed)
                        {
                            sdlPanel.UpdateYUVTexture(
                                frameData.p_y,
                                frameData.p_u,
                                frameData.p_v,
                                frameData.pitch_y,
                                frameData.pitch_u,
                                frameData.pitch_v,
                                frameData.w,
                                frameData.h
                            );

                            if (_captureImage)
                            {
                                _captureImage = false;

                                // Convert YUV data to Bitmap
                                Bitmap capturedImage = YuvToBitmap(frameData);

                                // Save to desktop or prompt for location
                                SaveCapturedImage(capturedImage);
                            }
                        }
                    }));
                }
                catch (ObjectDisposedException)
                {
                    break;
                }


                System.Threading.Thread.Sleep(10);
                SLcamNet.l_sdk_dec_free_md_data(frameDataPtr);
            }
        }


        private void AdjustSDLPanelSize()
        {
            if (sdlPanel == null || panel1.Width == 0 || panel1.Height == 0) return;

            // 原始SDLPanel的宽高比
            float aspectRatio = (float)sdlPanel.VideoWidth / sdlPanel.VideoHeight;

            int panelWidth = panel1.Width;
            int panelHeight = panel1.Height;

            int sdlPanelWidth, sdlPanelHeight;

            // 根据宽高比和父容器的大小计算新的大小，保持比例
            if (panelWidth / (float)panelHeight > aspectRatio)
            {
                // 限制在高度上
                sdlPanelHeight = panelHeight;
                sdlPanelWidth = (int)(sdlPanelHeight * aspectRatio);
            }
            else
            {
                // 限制在宽度上
                sdlPanelWidth = panelWidth;
                sdlPanelHeight = (int)(sdlPanelWidth / aspectRatio);
            }

            // 设置SDLPanel的新大小
            sdlPanel.Size = new Size(sdlPanelWidth, sdlPanelHeight);

            // 调整SDLPanel位置使其居中
            sdlPanel.Location = new Point((panel1.Width - sdlPanel.Width) / 2, (panel1.Height - sdlPanel.Height) / 2);
        }

        private void devList_cBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            // _captureContext.resolution = getResolution(resolu_cBox.SelectedItem.ToString());
            // _slcam.SetCaptureContext(ref _captureContext);
            // 接下来设置它的初始大小和位置
        }

        private void autoFocus_checkBox_CheckedChanged(object sender, EventArgs e)
        {
            focus_tBar.Enabled = !autoFocus_checkBox.Checked;
            if (autoFocus_checkBox.Checked)
            {
                // _camera.GetControlInfo();
                _cameraInfo.Focus.Mode = FocusMode.kFocusAuto;
                SLcamNet.NetCamera.LOG("focus auto");
            }
            else
            {
                _camera.GetFocusInfo();
                _cameraInfo.Focus.Mode = FocusMode.kFocusManual;
                focus_tBar.Value = _cameraInfo.Focus.Value.Cur;
                focus_lab.Text = focus_tBar.Value.ToString();
                SLcamNet.NetCamera.LOG("focus Manual");
            }

            _camera.SetFocus(
                _cameraInfo.Focus.Mode, _cameraInfo.Focus.Value.Cur,
                _cameraInfo.Focus.Speed.Def);
        }

        private void focus_tBar_ValueChanged(object sender, EventArgs e)
        {
            focus_lab.Text = focus_tBar.Value.ToString();
            _camera.SetFocus(FocusMode.kFocusManual, focus_tBar.Value, _cameraInfo.Focus.Speed.Cur);

            // M 系列为加减聚焦
            // _camera.FocusAdd();
            // _camera.FocusSub();
        }

        private void autoExp_checkBox_CheckedChanged(object sender, EventArgs e)
        {
            if (autoExp_checkBox.Checked)
                _camera.SetExposure(ExposureMode.kExpAuto, _cameraInfo.Exposure.Bright.Cur,
                    _cameraInfo.Exposure.Gain.Cur,
                    _cameraInfo.Exposure.Time.Cur);
            else
            {
                _camera.SetExposure(ExposureMode.kExpManual, _cameraInfo.Exposure.Bright.Cur,
                    _cameraInfo.Exposure.Gain.Cur,
                    _cameraInfo.Exposure.Time.Cur);
            }
        }

        private void autoWB_checkBoz_CheckedChanged(object sender, EventArgs e)
        {
            if (autoWB_checkBoz.Checked)
            {
                red_tBar.Enabled = green_tBar.Enabled = blue_tBar.Enabled = false;
                _cameraInfo = _camera.GetNetCameraAllInfo();
                _camera.SetWb(WbMode.kWBAuto, _cameraInfo.WhiteBalance.Red.Cur, _cameraInfo.WhiteBalance.Green.Cur,
                    _cameraInfo.WhiteBalance.Blue.Cur);
            }
            else
            {
                _camera.GetWbInfo();
                red_tBar.Enabled = green_tBar.Enabled = blue_tBar.Enabled = true;
                red_tBar.Value = _cameraInfo.WhiteBalance.Red.Cur;
                green_tBar.Value = _cameraInfo.WhiteBalance.Green.Cur;
                blue_tBar.Value = _cameraInfo.WhiteBalance.Blue.Cur;
                _camera.SetWb(WbMode.kWBManual, _cameraInfo.WhiteBalance.Red.Cur, _cameraInfo.WhiteBalance.Green.Cur,
                    _cameraInfo.WhiteBalance.Blue.Cur);
            }
        }

        private void red_tBar_ValueChanged(object sender, EventArgs e)
        {
            _cameraInfo.WhiteBalance.Red.Cur = red_tBar.Value;
            _camera.SetWb(WbMode.kWBManual, _cameraInfo.WhiteBalance.Red.Cur, _cameraInfo.WhiteBalance.Green.Cur,
                _cameraInfo.WhiteBalance.Blue.Cur);
        }

        private void green_tBar_ValueChanged(object sender, EventArgs e)
        {
            _cameraInfo.WhiteBalance.Green.Cur = green_tBar.Value;
            _camera.SetWb(WbMode.kWBManual, _cameraInfo.WhiteBalance.Red.Cur, _cameraInfo.WhiteBalance.Green.Cur,
                _cameraInfo.WhiteBalance.Blue.Cur);
        }

        private void blue_tBar_ValueChanged(object sender, EventArgs e)
        {
            _cameraInfo.WhiteBalance.Blue.Cur = blue_tBar.Value;
            _camera.SetWb(WbMode.kWBManual, _cameraInfo.WhiteBalance.Red.Cur, _cameraInfo.WhiteBalance.Green.Cur,
                _cameraInfo.WhiteBalance.Blue.Cur);
        }

        private void resolu_cBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            var cameraSettings = _camera.GetCameraSettings();
            cameraSettings.Resolution = getResolution(resolu_cBox.SelectedItem.ToString());
            // _camera.Close();
            _camera.ChangeStreamSettings(cameraSettings);

            int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
            int newHeight = ClientRectangle.Height - 8;
            panel1.Width = newWidth;
            panel1.Height = newHeight;
            sdlPanel.Size = new Size(cameraSettings.Resolution.Width, cameraSettings.Resolution.Height);
            sdlPanel.Location = new Point(10, 10);
            // 将SDLPanel添加到MainForm的控件集合中
            this.panel1.Controls.Add(sdlPanel);
            sdlPanel.AdjustTextureSize(cameraSettings.Resolution.Width, cameraSettings.Resolution.Height);
            AdjustSDLPanelSize();
        }

        private CameraResolution getResolution(string resolotionStr)
        {
            var strings = resolotionStr.Split('*');
            var resolution = new CameraResolution(int.Parse(strings[0].Trim()), int.Parse(strings[1].Trim()));
            return resolution;
        }

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
            int newHeight = ClientRectangle.Height - 8;

            panel1.Width = newWidth;
            panel1.Height = newHeight;
            AdjustSDLPanelSize();
        }

        public Bitmap YuvToBitmap(SLcamNet.l_md_data_t frameData)
        {
            // 创建一个Bitmap对象
            Bitmap bmp = new Bitmap(frameData.w, frameData.h, PixelFormat.Format24bppRgb);

            // 锁定Bitmap的位图数据
            BitmapData bmpData = bmp.LockBits(new Rectangle(0, 0, frameData.w, frameData.h),
                ImageLockMode.WriteOnly,
                bmp.PixelFormat);

            // 获取Bitmap数据的指针
            IntPtr ptr = bmpData.Scan0;

            // 创建一个临时RGB数据数组
            int bytes = Math.Abs(bmpData.Stride) * frameData.h;
            byte[] rgbValues = new byte[bytes];

            // 转换YUV数据到RGB数据
            DecodeYUV420(rgbValues, frameData.p_y, frameData.p_u, frameData.p_v, frameData.pitch_y, frameData.pitch_u,
                frameData.pitch_v, frameData.w, frameData.h);

            // 将RGB数据复制到Bitmap数据
            Marshal.Copy(rgbValues, 0, ptr, bytes);

            // 解锁Bitmap数据
            bmp.UnlockBits(bmpData);

            return bmp;
        }

        private static void DecodeYUV420(byte[] rgbData, IntPtr yPtr, IntPtr uPtr, IntPtr vPtr, int pitchY, int pitchU,
            int pitchV, int width, int height)
        {
            // 将IntPtr转换为byte数组
            byte[] yPlane = new byte[pitchY * height];
            byte[] uPlane = new byte[pitchU * (height / 2)];
            byte[] vPlane = new byte[pitchV * (height / 2)];

            Marshal.Copy(yPtr, yPlane, 0, yPlane.Length);
            Marshal.Copy(uPtr, uPlane, 0, uPlane.Length);
            Marshal.Copy(vPtr, vPlane, 0, vPlane.Length);

            int frameSize = width * height;

            for (int j = 0, yp = 0; j < height; j++)
            {
                int yIndex = j * pitchY;
                int uvIndex = (j >> 1) * pitchU;
                for (int i = 0; i < width; i++, yp++)
                {
                    int y = yPlane[yIndex + i] & 0xFF;
                    int u = uPlane[uvIndex + (i >> 1)] & 0xFF;
                    int v = vPlane[uvIndex + (i >> 1)] & 0xFF;

                    y = y < 16 ? 16 : y;

                    int r = (int)(1.164f * (y - 16) + 1.596f * (v - 128));
                    int g = (int)(1.164f * (y - 16) - 0.813f * (v - 128) - 0.391f * (u - 128));
                    int b = (int)(1.164f * (y - 16) + 2.018f * (u - 128));

                    r = r < 0 ? 0 : (r > 255 ? 255 : r);
                    g = g < 0 ? 0 : (g > 255 ? 255 : g);
                    b = b < 0 ? 0 : (b > 255 ? 255 : b);

                    int index = yp * 3;
                    rgbData[index] = (byte)b;
                    rgbData[index + 1] = (byte)g;
                    rgbData[index + 2] = (byte)r;
                }
            }
        }

        private void SaveCapturedImage(Bitmap image)
        {
            SaveFileDialog saveFileDialog = new SaveFileDialog
            {
                Filter = "PNG Image|*.png",
                Title = "Save Captured Image"
            };

            if (saveFileDialog.ShowDialog() == DialogResult.OK && saveFileDialog.FileName != "")
            {
                try
                {
                    image.Save(saveFileDialog.FileName, ImageFormat.Png);
                    MessageBox.Show($"Image saved to {saveFileDialog.FileName}");
                }
                catch (Exception ex)
                {
                    MessageBox.Show($"Failed to save image: {ex.Message}");
                }
            }

            image.Dispose();
        }

        private void saveImg_btn_Click(object sender, EventArgs e)
        {
            _captureImage = true;
        }
    }
}