﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace netsdkdemo
{
    public class ImageBoolSettings
    {
        public bool Flip { get; set; } = false;
        public bool Mirror { get; set; } = false;
        public bool Cac { get; set; } = false;
        public bool Flick { get; set; } = false;

        public bool Monochrome { get; set; } = false;

        // 新增
        public bool SharpnessEnhancement { get; set; } = false;
    }

    public class ImageValueSettings
    {
        public int Contrast { get; set; } = 0;
        public int Saturation { get; set; } = 0;
        public int Hue { get; set; } = 0;
        public int Sharpness { get; set; } = 0;
        public int Gamma { get; set; } = 0;
        public int Drc { get; set; } = 0;
        public int ContrastEnhancement { get; set; } = 0;
    }

    public sealed class NewNetCamera : SLcamNet.NetCamera
    {
        // 可供A3xx系列使用
        // private CameraInfo m_cameraInfo;
        // private int m_chnn;
        // private const int kStreamDecID = 100;
        // private int m_id;
        // private int m_idx;

        // getNetCameraAllInfo
        public override CameraInfo GetNetCameraAllInfo()
        {
            // 暂未使用
            // GetPicAbility();
            GetSystemBaseInfo();
            // GetStreamJson();
            GetStreamAbility();
            GetImageValueInfo();
            GetImageBoolInfo();
            GetFocusInfo();
            GetZoomInfo();
            GetFocusRegionInfo();
            GetFocusRegionInfoV2();
            GetExposureInfo();
            GetWbInfo();
            GetLedInfo();
            GetIpv4Info();
            GetImageAbility();
            GetMotorAbility();
            GetLedAbility();

            // 是否具有WIFI功能
            if (m_cameraInfo.ipInfo.EnWireless)
            {
                GetWirelessIpv4Info();
                GetWirelessInfo();
            }

            return m_cameraInfo;
        }

        public override JObject GetWirelessInfoJson()
        {
            var request = new JObject
            {
                { "cmd", "get_wireless" }
            };
            return GetRequest(request);
        }

        public override JObject GetWirelessIpv4InfoJson()
        {
            var request = new JObject
            {
                { "cmd", "get_wireless_ipv4" }
            };
            return GetRequest(request);
        }

        public override void GetWirelessInfo()
        {
            JObject wirelessInfoJson = GetWirelessInfoJson();
            if (wirelessInfoJson == null)
                return;
            try
            {
                var getWireless = wirelessInfoJson["get_wireless"];
                if (getWireless == null)
                    return;

                m_cameraInfo.ipInfo.WirelessType = getWireless["type"]?.ToString() ?? string.Empty;
                m_cameraInfo.ipInfo.WirelessNet = getWireless["net"]?.ToString() ?? string.Empty;

                bool apMode = string.Equals(m_cameraInfo.ipInfo.WirelessType, "AP", StringComparison.OrdinalIgnoreCase);

                if (getWireless["ap_ssid"] != null)
                {
                    m_cameraInfo.ipInfo.WirelessApSsid = getWireless["ap_ssid"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessApPasswd = getWireless["ap_passwd"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessStaSsid = getWireless["sta_ssid"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessStaPasswd = getWireless["sta_passwd"]?.ToString() ?? string.Empty;

                    if (apMode)
                    {
                        m_cameraInfo.ipInfo.WirelessSsid = m_cameraInfo.ipInfo.WirelessApSsid;
                        m_cameraInfo.ipInfo.WirelessPasswd = m_cameraInfo.ipInfo.WirelessApPasswd;
                    }
                    else
                    {
                        m_cameraInfo.ipInfo.WirelessSsid = m_cameraInfo.ipInfo.WirelessStaSsid;
                        m_cameraInfo.ipInfo.WirelessPasswd = m_cameraInfo.ipInfo.WirelessStaPasswd;
                    }
                }
                else
                {
                    m_cameraInfo.ipInfo.WirelessSsid = getWireless["ssid"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessPasswd = getWireless["passwd"]?.ToString() ?? string.Empty;

                    if (apMode)
                    {
                        m_cameraInfo.ipInfo.WirelessApSsid = m_cameraInfo.ipInfo.WirelessSsid;
                        m_cameraInfo.ipInfo.WirelessApPasswd = m_cameraInfo.ipInfo.WirelessPasswd;
                    }
                    else
                    {
                        m_cameraInfo.ipInfo.WirelessStaSsid = m_cameraInfo.ipInfo.WirelessSsid;
                        m_cameraInfo.ipInfo.WirelessStaPasswd = m_cameraInfo.ipInfo.WirelessPasswd;
                    }
                }

                string wirelessEnc = getWireless["enc"]?.ToString() ?? string.Empty;
            }
            catch (Exception e)
            {
                Console.WriteLine("GetWirelessInfo failed, JSON threw an error: " + e.Message);
            }

            SLcamNet.NetCamera.LOG("GetWirelessInfo: " + wirelessInfoJson.ToString());
        }

        public override void GetWirelessIpv4Info()
        {
            JObject wirelessInfoJson = GetWirelessInfoJson();
            if (wirelessInfoJson == null)
                return;

            try
            {
                var getWireless = wirelessInfoJson["get_wireless"];
                if (getWireless == null)
                    return;

                m_cameraInfo.ipInfo.WirelessType = getWireless["type"]?.ToString() ?? string.Empty;
                m_cameraInfo.ipInfo.WirelessNet = getWireless["net"]?.ToString() ?? string.Empty;

                bool apMode = string.Equals(m_cameraInfo.ipInfo.WirelessType, "AP", StringComparison.OrdinalIgnoreCase);

                if (getWireless["ap_ssid"] != null)
                {
                    m_cameraInfo.ipInfo.WirelessApSsid = getWireless["ap_ssid"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessApPasswd = getWireless["ap_passwd"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessStaSsid = getWireless["sta_ssid"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessStaPasswd = getWireless["sta_passwd"]?.ToString() ?? string.Empty;

                    if (apMode)
                    {
                        m_cameraInfo.ipInfo.WirelessSsid = m_cameraInfo.ipInfo.WirelessApSsid;
                        m_cameraInfo.ipInfo.WirelessPasswd = m_cameraInfo.ipInfo.WirelessApPasswd;
                    }
                    else
                    {
                        m_cameraInfo.ipInfo.WirelessSsid = m_cameraInfo.ipInfo.WirelessStaSsid;
                        m_cameraInfo.ipInfo.WirelessPasswd = m_cameraInfo.ipInfo.WirelessStaPasswd;
                    }
                }
                else
                {
                    m_cameraInfo.ipInfo.WirelessSsid = getWireless["ssid"]?.ToString() ?? string.Empty;
                    m_cameraInfo.ipInfo.WirelessPasswd = getWireless["passwd"]?.ToString() ?? string.Empty;

                    if (apMode)
                    {
                        m_cameraInfo.ipInfo.WirelessApSsid = m_cameraInfo.ipInfo.WirelessSsid;
                        m_cameraInfo.ipInfo.WirelessApPasswd = m_cameraInfo.ipInfo.WirelessPasswd;
                    }
                    else
                    {
                        m_cameraInfo.ipInfo.WirelessStaSsid = m_cameraInfo.ipInfo.WirelessSsid;
                        m_cameraInfo.ipInfo.WirelessStaPasswd = m_cameraInfo.ipInfo.WirelessPasswd;
                    }
                }

                string wirelessEnc = getWireless["enc"]?.ToString() ?? string.Empty;
            }
            catch (Exception e)
            {
                Console.WriteLine("GetWirelessInfo failed, JSON threw an error: " + e.Message);
            }

            SLcamNet.NetCamera.LOG("GetWirelessInfo: " + wirelessInfoJson.ToString());
        }

        private void GetFocusRegionInfoV2()
        {
            JObject focusRegionJson = GetFocusRegionInfoJsonV2();
            if (focusRegionJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("focusRegionJsonV2: " + focusRegionJson.ToString());

                m_cameraInfo.Focus.RegionV2.Enable = focusRegionJson["get_focus_region"]["roi"].Value<bool>();
                m_cameraInfo.Focus.RegionV2.X = focusRegionJson["get_focus_region"]["roi_x"].Value<int>();
                m_cameraInfo.Focus.RegionV2.Y = focusRegionJson["get_focus_region"]["roi_y"].Value<int>();
                m_cameraInfo.Focus.RegionV2.Width = focusRegionJson["get_focus_region"]["roi_width"].Value<int>();
                m_cameraInfo.Focus.RegionV2.Height = focusRegionJson["get_focus_region"]["roi_height"].Value<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("Json threw an error: " + e.Message);
            }
        }

        private JObject GetFocusRegionInfoJsonV2()
        {
            var request = new JObject
            {
                { "cmd", "get_focus_region" },
                {
                    "get_focus_region", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };

            return GetRequest(request);
        }

        public bool SetFocusRegionV2(bool enable, int x, int y, int width, int height)
        {
            m_cameraInfo.Focus.RegionV2.Enable = enable;
            m_cameraInfo.Focus.RegionV2.X = x;
            m_cameraInfo.Focus.RegionV2.Y = y;
            m_cameraInfo.Focus.RegionV2.Width = width;
            m_cameraInfo.Focus.RegionV2.Height = height;

            JObject request = new JObject
            {
                { "cmd", "set_focus_region" },
                {
                    "set_focus_region", new JObject
                    {
                        { "chnn", m_chnn },
                        { "roi", m_cameraInfo.Focus.RegionV2.Enable },
                        { "roi_x", m_cameraInfo.Focus.RegionV2.X },
                        { "roi_y", m_cameraInfo.Focus.RegionV2.Y },
                        { "roi_width", m_cameraInfo.Focus.RegionV2.Width },
                        { "roi_height", m_cameraInfo.Focus.RegionV2.Height }
                    }
                }
            };

            return SetRequest(request);
        }

        public void GetSystemBaseInfo()
        {
            JObject systemBaseJson = GetSystemBaseJson();
            if (systemBaseJson == null)
                return;

            //SLcamNet.NetCamera.LOG("getSystemBaseInfo: " + systemBaseJson.ToString(Formatting.None));
        }

        public JObject GetSystemBaseJson()
        {
            var request = new JObject
            {
                ["cmd"] = "system"
            };
            return GetRequest(request);
        }

        public JObject GetRequest(JObject requestJson)
        {
            string request = requestJson.ToString(Formatting.None);
            SLcamNet.l_sdk_request(m_id, request, out IntPtr resultStr);

            if (resultStr == IntPtr.Zero)
            {
                SLcamNet.NetCamera.LOG("Get request failed resultStr");
                return null;
            }

            string result = Marshal.PtrToStringAnsi(resultStr);
            SLcamNet.l_sdk_free(resultStr);

            JObject resJson = JObject.Parse(result);
            //SLcamNet.NetCamera.LOG(resJson.ToString());
            int code = resJson[requestJson["cmd"].ToString()]["code"].ToObject<int>();

            if (code != 0)
            {
                SLcamNet.NetCamera.LOG("Get request failed code != 0");
                return null;
            }

            return resJson;
        }

        public override bool SetFocus(FocusMode mode, int value, int speed)
        {
            m_cameraInfo.Focus.Mode = mode;
            m_cameraInfo.Focus.Value.Cur = value;
            m_cameraInfo.Focus.Speed.Cur = value;

            int focusMode = SLcamNet.NetCamera.ConvertNetFocusMode(mode);
            var request = new JObject
            {
                ["cmd"] = "set_focus",
                ["set_focus"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["focus_mode"] = focusMode,
                    ["focus_value"] = m_cameraInfo.Focus.Value.Cur,
                    ["focus_speed"] = m_cameraInfo.Focus.Speed.Cur
                }
            };
            return SetRequest(request);
        }

        public override bool SetFocusRegion(bool enable, int x, int y, int mode)
        {
            m_cameraInfo.Focus.Region.Enable = enable;
            m_cameraInfo.Focus.Region.X.Cur = x;
            m_cameraInfo.Focus.Region.Y.Cur = y;
            m_cameraInfo.Focus.Region.Mode = mode;
            var request = new JObject
            {
                ["cmd"] = "set_roi",
                ["set_roi"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["roi"] = m_cameraInfo.Focus.Region.Enable,
                    ["roi_x"] = m_cameraInfo.Focus.Region.X.Cur,
                    ["roi_y"] = m_cameraInfo.Focus.Region.Y.Cur,
                    ["roi_mode"] = mode
                }
            };
            return SetRequest(request);
        }

        public override bool SetExposure(ExposureMode mode, int compensation, int gain, int shutterTime)
        {
            m_cameraInfo.Exposure.Mode = mode;
            m_cameraInfo.Exposure.Bright.Cur = compensation;
            m_cameraInfo.Exposure.Gain.Cur = gain;
            m_cameraInfo.Exposure.Time.Cur = shutterTime;

            int exposureMode = SLcamNet.NetCamera.ConvertNetExposureMode(mode);
            var request = new JObject
            {
                ["cmd"] = "set_exposure",
                ["set_exposure"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["expo_type"] = exposureMode,
                    ["compensation"] = m_cameraInfo.Exposure.Bright.Cur,
                    ["shuttertime"] = m_cameraInfo.Exposure.Time.Cur,
                    ["a_gain"] = m_cameraInfo.Exposure.Gain.Cur
                }
            };
            return SetRequest(request);
        }

        public override bool SetWb(WbMode mode, int red, int green, int blue)
        {
            m_cameraInfo.WhiteBalance.Mode = mode;
            m_cameraInfo.WhiteBalance.Red.Cur = red;
            m_cameraInfo.WhiteBalance.Green.Cur = green;
            m_cameraInfo.WhiteBalance.Blue.Cur = blue;

            int wbMode = SLcamNet.NetCamera.ConvertNetWhiteBalanceMode2(mode);
            var request = new JObject
            {
                ["cmd"] = "set_white_balance",
                ["set_white_balance"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["awb"] = wbMode,
                    ["b"] = m_cameraInfo.WhiteBalance.Blue.Cur,
                    ["gb"] = m_cameraInfo.WhiteBalance.Green.Cur,
                    ["gr"] = m_cameraInfo.WhiteBalance.Green.Cur,
                    ["r"] = m_cameraInfo.WhiteBalance.Red.Cur
                }
            };
            return SetRequest(request);
        }

        public override bool SetZoom(int ezoomValue, int dzoomValue, int speed, ZoomMode mode = ZoomMode.ZoomAbsolute)
        {
            if (ezoomValue > m_cameraInfo.Zoom.Max)
                ezoomValue = m_cameraInfo.Zoom.Max;

            if (dzoomValue > m_cameraInfo.Dzoom.Max)
                dzoomValue = m_cameraInfo.Dzoom.Max;

            m_cameraInfo.Zoom.Cur = ezoomValue;
            m_cameraInfo.Dzoom.Cur = dzoomValue;
            m_cameraInfo.ZoomSpeed.Cur = speed;
            var request = new JObject
            {
                ["cmd"] = "set_zoom",
                ["set_zoom"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["ezoom_value"] = m_cameraInfo.Zoom.Cur,
                    ["dzoom_value"] = m_cameraInfo.Dzoom.Cur,
                    ["ezoom_speed"] = m_cameraInfo.ZoomSpeed.Cur,
                    ["ezoom_mode"] = ((int)mode)
                }
            };
            return SetRequest(request);
        }

        public override bool SetFlip(bool enable)
        {
            m_cameraInfo.Flip = enable;
            return SetImageBool(CollectImageBoolSettings());
        }

        public override bool SetMirror(bool enable)
        {
            m_cameraInfo.Mirror = enable;
            return SetImageBool(CollectImageBoolSettings());
        }

        public override bool SetCAC(bool enable)
        {
            m_cameraInfo.Cac = enable;
            return SetImageBool(CollectImageBoolSettings());
        }

        public override bool SetFlick(bool enable)
        {
            m_cameraInfo.PowerlineFrequency = enable;
            return SetImageBool(CollectImageBoolSettings());
        }

        public override bool SetMonochrome(bool enable)
        {
            m_cameraInfo.Monochrome = enable;
            return SetImageBool(CollectImageBoolSettings());
        }

        public bool SetLed(int partIndex, int level)
        {
            for (int i = 0; i < m_cameraInfo.Led.LedPartVec.Count; i++)
            {
                var part = m_cameraInfo.Led.LedPartVec[i];
                if (part.Index == partIndex)
                {
                    part.Level = level;
                    m_cameraInfo.Led.LedPartVec[i] = part; // 更新列表中的元素

                    var request = new JObject
                    {
                        ["cmd"] = "set_led",
                        ["set_led"] = new JObject
                        {
                            ["chnn"] = m_chnn,
                            ["index"] = partIndex,
                            ["level"] = part.Level
                        }
                    };
                    return SetRequest(request);
                }
            }

            return false;
        }

        public bool SetContrastValue(int value)
        {
            m_cameraInfo.Contrast.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public bool SetSaturationValue(int value)
        {
            m_cameraInfo.Saturation.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public bool SetHueValue(int value)
        {
            m_cameraInfo.Hue.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public bool SetSharpnessValue(int value)
        {
            m_cameraInfo.Sharpness.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public bool SetGammaValue(int value)
        {
            m_cameraInfo.Gamma.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public bool SetDRCValue(int value)
        {
            m_cameraInfo.Drc.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public override bool SetDefog(bool enable)
        {
            m_cameraInfo.Defog = enable;
            JObject request = new JObject
            {
                { "cmd", "set_motor_demist" },
                {
                    "set_motor_demist", new JObject
                    {
                        { "chnn", m_chnn },
                        { "demist", m_cameraInfo.Defog }
                    }
                }
            };
            return SetRequest(request);
        }

        public override void GetDefogStatus()
        {
            JObject resJson = GetDefogStatusJson();
            if (resJson == null)
                return;

            try
            {
                m_cameraInfo.Defog = resJson["get_motor_demist"]?["demist"]?.ToObject<bool>() ?? false;
            }
            catch (Exception e)
            {
                Console.WriteLine($"GetDefogStatus threw an error: {e.Message}");
            }
        }

        public override JObject GetDefogStatusJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_motor_demist" },
                {
                    "get_motor_demist", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        public bool SetImageValue(ImageValueSettings settings)
        {
            var request = new JObject
            {
                ["cmd"] = "set_image_value",
                ["set_image_value"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["contrast"] = settings.Contrast,
                    ["saturation"] = settings.Saturation,
                    ["hue"] = settings.Hue,
                    ["sharpness"] = settings.Sharpness,
                    ["gamma"] = settings.Gamma,
                    ["drc"] = settings.Drc
                }
            };

            return SetRequest(request);
        }

        public bool SetImageBool(ImageBoolSettings settings)
        {
            var request = new JObject
            {
                ["cmd"] = "set_image_bool",
                ["set_image_bool"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["flip"] = settings.Flip,
                    ["mirror"] = settings.Mirror,
                    ["cac"] = settings.Cac,
                    ["flick"] = settings.Flick,
                    ["monochrome"] = settings.Monochrome,
                    ["enhance"] = settings.SharpnessEnhancement
                }
            };

            return SetRequest(request);
        }

        // 新版调节亮度值接口，值为-1时关闭, 在范围内时启用
        private bool SetLeds(int up, int left, int right, int down)
        {
            var request = new JObject
            {
                ["cmd"] = "set_leds",
                ["set_leds"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["led0"] = up,
                    ["led1"] = left,
                    ["led2"] = right,
                    ["led3"] = down
                }
            };

            return SetRequest(request);
        }

        public override bool SetScene(int mode)
        {
            m_cameraInfo.SceneMode = mode;
            var request = new JObject
            {
                ["cmd"] = "set_scene_mode",
                ["set_scene_mode"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["mode"] = mode
                }
            };
            return SetRequest(request);
        }

        public override bool SetSharpnessEnhancement(bool enable)
        {
            m_cameraInfo.SharpnessEnhancement = enable;
            return SetImageBool(CollectImageBoolSettings());
        }

        public override bool SetContrastEnhancementValue(int value)
        {
            m_cameraInfo.ContrastEnhancement.Cur = value;
            return SetImageValue(CollectImageValueSettings());
        }

        public override bool SetWbTemperature(int temperature)
        {
            m_cameraInfo.WhiteBalance.Temperature.Cur = temperature;

            int wbMode = ConvertNetWhiteBalanceMode2(m_cameraInfo.WhiteBalance.Mode);

            var request = new JObject
            {
                ["cmd"] = "set_white_balance",
                ["set_white_balance"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["awb"] = wbMode,
                    ["b"] = m_cameraInfo.WhiteBalance.Blue.Cur,
                    ["gb"] = m_cameraInfo.WhiteBalance.Green.Cur,
                    ["gr"] = m_cameraInfo.WhiteBalance.Green.Cur,
                    ["r"] = m_cameraInfo.WhiteBalance.Red.Cur,
                    ["use_temperature"] = true,
                    ["color_temperature"] = m_cameraInfo.WhiteBalance.Temperature.Cur
                }
            };

            return SetRequest(request);
        }

        private void GetImageValueInfo()
        {
            JObject imgRecJson = GetImageValueInfoJson();
            if (imgRecJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("imgRecJson: " + imgRecJson.ToString());
                m_cameraInfo.Contrast.Cur = imgRecJson["get_image_value"]["contrast"].ToObject<int>();
                m_cameraInfo.Saturation.Cur = imgRecJson["get_image_value"]["saturation"].ToObject<int>();
                m_cameraInfo.Hue.Cur = imgRecJson["get_image_value"]["hue"].ToObject<int>();
                m_cameraInfo.Sharpness.Cur = imgRecJson["get_image_value"]["sharpness"].ToObject<int>();
                m_cameraInfo.Gamma.Cur = imgRecJson["get_image_value"]["gamma"].ToObject<int>();
                m_cameraInfo.Drc.Cur = imgRecJson["get_image_value"]["drc"].ToObject<int>();
                // 新增字段
                if (imgRecJson["get_image_value"]["contrast_enhance"] != null)
                {
                    m_cameraInfo.ContrastEnhancement.Cur =
                        imgRecJson["get_image_value"]["contrast_enhance"].Value<int>();
                }
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        private void GetImageBoolInfo()
        {
            JObject imgRecJson = GetImageBoolInfoJson();
            if (imgRecJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("imgRecJson: " + imgRecJson.ToString());
                m_cameraInfo.Mirror = imgRecJson["get_image_bool"]["mirror"].ToObject<bool>();
                m_cameraInfo.Flip = imgRecJson["get_image_bool"]["flip"].ToObject<bool>();
                m_cameraInfo.PowerlineFrequency = imgRecJson["get_image_bool"]["flick"].ToObject<bool>();
                m_cameraInfo.Cac = imgRecJson["get_image_bool"]["cac"].ToObject<bool>();
                m_cameraInfo.Monochrome = imgRecJson["get_image_bool"]["monochrome"].ToObject<bool>();
                if (imgRecJson["get_image_bool"]["enhance"] != null)
                {
                    m_cameraInfo.SharpnessEnhancement = imgRecJson["get_image_bool"]["enhance"].Value<bool>();
                }
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetExposureInfo()
        {
            JObject exposureRecJson = GetExposureInfoJson();
            if (exposureRecJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("exposureRecJson: " + exposureRecJson.ToString());
                m_cameraInfo.Exposure.Mode = (ExposureMode)exposureRecJson["get_exposure"]["expo_type"].ToObject<int>();
                m_cameraInfo.Exposure.Bright.Cur = exposureRecJson["get_exposure"]["compensation"].ToObject<int>();
                m_cameraInfo.Exposure.Time.Cur = exposureRecJson["get_exposure"]["shuttertime"].ToObject<int>();
                m_cameraInfo.Exposure.Gain.Cur = exposureRecJson["get_exposure"]["a_gain"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetWbInfo()
        {
            JObject wbInfoJson = GetWbInfoJson();
            if (wbInfoJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("wbInfoJson: " + wbInfoJson.ToString());
                m_cameraInfo.WhiteBalance.Mode = (WbMode)wbInfoJson["get_white_balance"]["awb"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Red.Cur = wbInfoJson["get_white_balance"]["r"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Green.Cur = wbInfoJson["get_white_balance"]["gb"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Blue.Cur = wbInfoJson["get_white_balance"]["b"].ToObject<int>();
                // 新增字段
                if (wbInfoJson["get_white_balance"] != null &&
                    wbInfoJson["get_white_balance"]["color_temperature"] != null)
                {
                    m_cameraInfo.WhiteBalance.Temperature.Cur =
                        wbInfoJson["get_white_balance"]["color_temperature"].ToObject<int>();
                }
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetFocusInfo()
        {
            JObject focusJson = GetFocusInfoJson();
            if (focusJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("focusJson: " + focusJson.ToString());
                m_cameraInfo.Focus.Mode = (FocusMode)focusJson["get_focus"]["focus_mode"].ToObject<int>();
                m_cameraInfo.Focus.Value.Cur = focusJson["get_focus"]["focus_value"].ToObject<int>();
                m_cameraInfo.Focus.Speed.Cur = focusJson["get_focus"]["focus_speed"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public void GetFocusRegionInfo()
        {
            JObject focusRegionJson = GetFocusRegionInfoJson();
            if (focusRegionJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("focusRegionJson: " + focusRegionJson.ToString());
                m_cameraInfo.Focus.Region.Enable = focusRegionJson["get_roi"]["roi"].ToObject<bool>();
                m_cameraInfo.Focus.Region.Mode = focusRegionJson["get_roi"]["roi_mode"].ToObject<int>();
                m_cameraInfo.Focus.Region.X.Cur = focusRegionJson["get_roi"]["roi_x"].ToObject<int>();
                m_cameraInfo.Focus.Region.Y.Cur = focusRegionJson["get_roi"]["roi_y"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetZoomInfo()
        {
            JObject zoomJson = GetZoomInfoJson();
            if (zoomJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("zoomJson: " + zoomJson.ToString());
                m_cameraInfo.Zoom.Cur = zoomJson["get_zoom"]["ezoom_value"].ToObject<int>();
                m_cameraInfo.Dzoom.Cur = zoomJson["get_zoom"]["dzoom_value"].ToObject<int>();
                m_cameraInfo.ZoomSpeed.Cur = zoomJson["get_zoom"]["ezoom_speed"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public void GetLedInfo()
        {
            JObject ledJson = GetLedInfoJson();
            if (ledJson == null)
                return;

            try
            {
                SLcamNet.NetCamera.LOG("ledJson: " + ledJson.ToString());
                JArray infoJson = (JArray)ledJson["get_led"]["led_info"];
                int infoNum = infoJson.Count;
                m_cameraInfo.Led.LedPartVec = new List<LedPartInfo>();
                for (int i = 0; i < infoNum; ++i)
                {
                    // 读取 JSON 字段并进行转换
                    var index = (int)infoJson[i]["index"];
                    var enableValue = (int)infoJson[i]["enable"]; // 直接读取为 int
                    var enable = enableValue == 1; // 将 0 和 1 转换为 bool
                    var level = (int)infoJson[i]["level"];

                    // 创建 LedPartInfo 实例
                    LedPartInfo info = new LedPartInfo(index, enable, level);
                    m_cameraInfo.Led.LedPartVec.Add(info);
                }
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetIpv4Info()
        {
            JObject ipv4InfoJson = GetIpv4InfoJson();
            if (ipv4InfoJson == null)
                return;

            try
            {
                var getIpv4 = ipv4InfoJson["get_ipv4"];

                m_cameraInfo.ipInfo.Dhcp = getIpv4["dhcp"].ToObject<bool>();
                m_cameraInfo.ipInfo.Ip = getIpv4["ip"].ToString();
                m_cameraInfo.ipInfo.Gateway = getIpv4["gateway"].ToString();
                m_cameraInfo.ipInfo.Netmask = getIpv4["netmask"].ToString();
                m_cameraInfo.ipInfo.Dns1 = getIpv4["dns1"].ToString();
                m_cameraInfo.ipInfo.Dns2 = getIpv4["dns2"].ToString();
            }
            catch (Exception e)
            {
                Console.WriteLine("GetIpv4Info failed, JSON threw an error: " + e.Message);
            }

            SLcamNet.NetCamera.LOG("getIpv4Info: " + ipv4InfoJson.ToString());
        }

        public void GetStreamAbility()
        {
            // json示例
            /*
             {
                "get_stream_ability": {
                    "frame_rate": {
                        "max": 60,
                        "min": 1,
                        "def": 60
                    },
                    "bitrate": {
                        "max": 163840,
                        "min": 512,
                        "def": 163840
                    },
                    "fmt": ["mjpeg"],
                    "quality": {
                        "max": 6,
                        "min": 0,
                        "def": 4
                    },
                    "i_interval": {
                        "max": 120,
                        "min": 1,
                        "def": 120
                    },
                    "code": 0,
                    "wh": [
                    "960*540",
                    "1280*720",
                    "1920*1080"
                        ],
                    "rc_mode": ["cbr","vbr"],
                    "chnn": 0
                },
                "cmd": "get_stream_ability"
            }
            */

            JObject streamAbilityJson = GetStreamAbilityJson();
            if (streamAbilityJson == null)
                return;
            SLcamNet.NetCamera.LOG("streamAbilityJson: " + streamAbilityJson.ToString());
        }

        public void GetPicAbility()
        {
            JObject picAbilityJson = GetPicAbilityJson();
            if (picAbilityJson == null)
                return;
            //SLcamNet.NetCamera.LOG("picAbilityJson: " + picAbilityJson.ToString());
        }

        public void GetImageAbility()
        {
            /*
        {
             "hue": {
                "max": 100,
                "min": 0,
                "def": 50
            },
            "gb": {
                "max": 4095,
                "min": 1,
                "def": 256
            },
            "b": {
                "max": 4095,
                "min": 1,
                "def": 434
            },
            "code": 0,
            "drc": {
                "max": 255,
                "min": 0,
                "def": 100
            },
            "a_gain": {
                "max": 30,
                "min": 0,
                "def": 0
            },
            "awb": [
            0,
            1
                ],
            "contrast": {
                "max": 100,
                "min": 0,
                "def": 60
            },
            "r": {
                "max": 4095,
                "min": 1,
                "def": 518
            },
            "chnn": 0,
            "sharpness": {
                "max": 15,
                "min": 0,
                "def": 4
            },
            "gr": {
                "max": 4095,
                "min": 1,
                "def": 256
            },
            "shuttertime": {
                "max": 66,
                "min": 0,
                "def": 33
            },
            "compensation": {
                "max": 255,
                "min": 0,
                "def": 40
            },
            "saturation": {
                "max": 255,
                "min": 0,
                "def": 128
            },
            "gamma": {
                "max": 170,
                "min": 1,
                "def": 100
            },
            "expo_type": [
            0,
            1
                ]
        }
        */

            try
            {
                JObject imageAbilityJson = GetImageAbilityJson();
                if (imageAbilityJson == null)
                    return;
                imageAbilityJson = GetImageAbilityJson()["get_image_ability"].ToObject<JObject>();

                //SLcamNet.NetCamera.LOG("imageAbilityJson: " + imageAbilityJson.ToString());

                m_cameraInfo.Exposure.Bright.Min = imageAbilityJson["compensation"]["min"].ToObject<int>();
                m_cameraInfo.Exposure.Bright.Max = imageAbilityJson["compensation"]["max"].ToObject<int>();
                m_cameraInfo.Exposure.Bright.Def = imageAbilityJson["compensation"]["def"].ToObject<int>();
                m_cameraInfo.Exposure.Gain.Min = imageAbilityJson["a_gain"]["min"].ToObject<int>();
                m_cameraInfo.Exposure.Gain.Max = imageAbilityJson["a_gain"]["max"].ToObject<int>();
                m_cameraInfo.Exposure.Gain.Def = imageAbilityJson["a_gain"]["def"].ToObject<int>();
                m_cameraInfo.Exposure.Time.Min = imageAbilityJson["shuttertime"]["min"].ToObject<int>();
                m_cameraInfo.Exposure.Time.Max = imageAbilityJson["shuttertime"]["max"].ToObject<int>();
                m_cameraInfo.Exposure.Time.Def = imageAbilityJson["shuttertime"]["def"].ToObject<int>();
                m_cameraInfo.Contrast.Min = imageAbilityJson["contrast"]["min"].ToObject<int>();
                m_cameraInfo.Contrast.Max = imageAbilityJson["contrast"]["max"].ToObject<int>();
                m_cameraInfo.Contrast.Def = imageAbilityJson["contrast"]["def"].ToObject<int>();
                m_cameraInfo.Saturation.Min = imageAbilityJson["saturation"]["min"].ToObject<int>();
                m_cameraInfo.Saturation.Max = imageAbilityJson["saturation"]["max"].ToObject<int>();
                m_cameraInfo.Saturation.Def = imageAbilityJson["saturation"]["def"].ToObject<int>();
                m_cameraInfo.Hue.Min = imageAbilityJson["hue"]["min"].ToObject<int>();
                m_cameraInfo.Hue.Max = imageAbilityJson["hue"]["max"].ToObject<int>();
                m_cameraInfo.Hue.Def = imageAbilityJson["hue"]["def"].ToObject<int>();
                m_cameraInfo.Sharpness.Min = imageAbilityJson["sharpness"]["min"].ToObject<int>();
                m_cameraInfo.Sharpness.Max = imageAbilityJson["sharpness"]["max"].ToObject<int>();
                m_cameraInfo.Sharpness.Def = imageAbilityJson["sharpness"]["def"].ToObject<int>();
                m_cameraInfo.Gamma.Min = imageAbilityJson["gamma"]["min"].ToObject<int>();
                m_cameraInfo.Gamma.Max = imageAbilityJson["gamma"]["max"].ToObject<int>();
                m_cameraInfo.Gamma.Def = imageAbilityJson["gamma"]["def"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Red.Min = imageAbilityJson["r"]["min"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Red.Max = imageAbilityJson["r"]["max"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Red.Def = imageAbilityJson["r"]["def"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Green.Min = imageAbilityJson["gr"]["min"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Green.Max = imageAbilityJson["gr"]["max"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Green.Def = imageAbilityJson["gr"]["def"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Blue.Min = imageAbilityJson["b"]["min"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Blue.Max = imageAbilityJson["b"]["max"].ToObject<int>();
                m_cameraInfo.WhiteBalance.Blue.Def = imageAbilityJson["b"]["def"].ToObject<int>();
                m_cameraInfo.Drc.Min = imageAbilityJson["drc"]["min"].ToObject<int>();
                m_cameraInfo.Drc.Max = imageAbilityJson["drc"]["max"].ToObject<int>();
                m_cameraInfo.Drc.Def = imageAbilityJson["drc"]["def"].ToObject<int>();
                // 后续新增字段
                if (imageAbilityJson.ContainsKey("contrast_enhance"))
                {
                    var contrastEnhance = imageAbilityJson["contrast_enhance"];
                    m_cameraInfo.ContrastEnhancement.Min = contrastEnhance["min"].Value<int>();
                    m_cameraInfo.ContrastEnhancement.Max = contrastEnhance["max"].Value<int>();
                    m_cameraInfo.ContrastEnhancement.Def = contrastEnhance["def"].Value<int>();
                }

                if (imageAbilityJson.ContainsKey("color_temperature"))
                {
                    var colorTemp = imageAbilityJson["color_temperature"];
                    if (colorTemp != null)
                    {
                        m_cameraInfo.WhiteBalance.Temperature.Min = colorTemp.Value<int>("min");
                        m_cameraInfo.WhiteBalance.Temperature.Max = colorTemp.Value<int>("max");
                        m_cameraInfo.WhiteBalance.Temperature.Def = colorTemp.Value<int>("def");
                    }
                }

                SLcamNet.NetCamera.LOG("imageAbilityJson: " + imageAbilityJson.ToString());
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public void GetMotorAbility()
        {
            try
            {
                JObject motorAbilityJson = GetMotorAbilityJson();
                if (motorAbilityJson == null)
                    return;
                motorAbilityJson = GetMotorAbilityJson()["get_motor_ability"].ToObject<JObject>();


                m_cameraInfo.Focus.Value.Min = motorAbilityJson["focus_value"]["min"].ToObject<int>();
                m_cameraInfo.Focus.Value.Max = motorAbilityJson["focus_value"]["max"].ToObject<int>();
                m_cameraInfo.Focus.Value.Def = motorAbilityJson["focus_value"]["def"].ToObject<int>();
                m_cameraInfo.Focus.Speed.Min = motorAbilityJson["focus_speed"]["min"].ToObject<int>();
                m_cameraInfo.Focus.Speed.Max = motorAbilityJson["focus_speed"]["max"].ToObject<int>();
                m_cameraInfo.Focus.Speed.Def = motorAbilityJson["focus_speed"]["def"].ToObject<int>();
                if (m_cameraInfo.Focus.Region.Mode == 0)
                {
                    m_cameraInfo.Focus.Region.X.Min = motorAbilityJson["roi_small_x"]["min"].ToObject<int>();
                    m_cameraInfo.Focus.Region.X.Max = motorAbilityJson["roi_small_x"]["max"].ToObject<int>();
                    m_cameraInfo.Focus.Region.X.Def = motorAbilityJson["roi_small_x"]["def"].ToObject<int>();
                    m_cameraInfo.Focus.Region.Y.Min = motorAbilityJson["roi_small_y"]["min"].ToObject<int>();
                    m_cameraInfo.Focus.Region.Y.Max = motorAbilityJson["roi_small_y"]["max"].ToObject<int>();
                    m_cameraInfo.Focus.Region.Y.Def = motorAbilityJson["roi_small_y"]["def"].ToObject<int>();
                }
                else
                {
                    m_cameraInfo.Focus.Region.X.Min = motorAbilityJson["roi_large_x"]["min"].ToObject<int>();
                    m_cameraInfo.Focus.Region.X.Max = motorAbilityJson["roi_large_x"]["max"].ToObject<int>();
                    m_cameraInfo.Focus.Region.X.Def = motorAbilityJson["roi_large_x"]["def"].ToObject<int>();
                    m_cameraInfo.Focus.Region.Y.Min = motorAbilityJson["roi_large_y"]["min"].ToObject<int>();
                    m_cameraInfo.Focus.Region.Y.Max = motorAbilityJson["roi_large_y"]["max"].ToObject<int>();
                    m_cameraInfo.Focus.Region.Y.Def = motorAbilityJson["roi_large_y"]["def"].ToObject<int>();
                }

                m_cameraInfo.Zoom.Min = motorAbilityJson["ezoom_value"]["min"].ToObject<int>();
                m_cameraInfo.Zoom.Max = motorAbilityJson["ezoom_value"]["max"].ToObject<int>();
                m_cameraInfo.Zoom.Def = motorAbilityJson["ezoom_value"]["def"].ToObject<int>();
                m_cameraInfo.Dzoom.Min = motorAbilityJson["dzoom_value"]["min"].ToObject<int>();
                m_cameraInfo.Dzoom.Max = motorAbilityJson["dzoom_value"]["max"].ToObject<int>();
                m_cameraInfo.Dzoom.Def = motorAbilityJson["dzoom_value"]["def"].ToObject<int>();
                m_cameraInfo.ZoomSpeed.Min = motorAbilityJson["ezoom_speed"]["min"].ToObject<int>();
                m_cameraInfo.ZoomSpeed.Max = motorAbilityJson["ezoom_speed"]["max"].ToObject<int>();
                m_cameraInfo.ZoomSpeed.Def = motorAbilityJson["ezoom_speed"]["def"].ToObject<int>();

                SLcamNet.NetCamera.LOG("motorAbilityJson: " + motorAbilityJson.ToString());
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public void GetLedAbility()
        {
            try
            {
                JObject ledAbilityJson = GetLedAbilityJson();
                if (ledAbilityJson == null)
                    return;
                ledAbilityJson = GetLedAbilityJson()["get_led_ability"].ToObject<JObject>();

                m_cameraInfo.Led.PartNumber = ledAbilityJson["part_number"].ToObject<int>();
                m_cameraInfo.Led.LevelRange.Min = ledAbilityJson["level"]["min"].ToObject<int>();
                m_cameraInfo.Led.LevelRange.Max = ledAbilityJson["level"]["max"].ToObject<int>();
                m_cameraInfo.Led.LevelRange.Def = ledAbilityJson["level"]["def"].ToObject<int>();
            }
            catch (Exception e)
            {
                SLcamNet.NetCamera.LOG("json throw an error:" + e.Message);
            }
        }

        public override void GetSceneInfo()
        {
            JObject resJson = GetSceneInfoJson();

            try
            {
                m_cameraInfo.SceneMode = resJson["get_scene_mode"]["mode"].Value<int>();
            }
            catch (Exception e)
            {
                Console.WriteLine("GetDefogStatus threw an error: " + e.Message);
            }
        }

        private JObject GetImageValueInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_image_value" },
                {
                    "get_image_value", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetImageBoolInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_image_bool" },
                {
                    "get_image_bool", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetExposureInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_exposure" },
                {
                    "get_exposure", new JObject
                    {
                        { "chnn", m_chnn }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetWbInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_white_balance" },
                {
                    "get_white_balance", new JObject
                    {
                        { "chnn", m_chnn }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetFocusInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_focus" },
                {
                    "get_focus", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetFocusRegionInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_roi" },
                {
                    "get_roi", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetZoomInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_zoom" },
                {
                    "get_zoom", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetLedInfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_led" },
                {
                    "get_led", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        public override JObject GetIpv4InfoJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_ipv4" }
            };
            return GetRequest(request);
        }

        private JObject GetStreamAbilityJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_stream_ability" },
                {
                    "get_stream_ability", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetPicAbilityJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_pic_ability" },
                {
                    "get_pic_ability", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetImageAbilityJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_image_ability" },
                {
                    "get_image_ability", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetMotorAbilityJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_motor_ability" },
                {
                    "get_motor_ability", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }

        private JObject GetLedAbilityJson()
        {
            JObject request = new JObject
            {
                { "cmd", "get_led_ability" },
                {
                    "get_led_ability", new JObject
                    {
                        { "chnn", m_chnn },
                        { "idx", m_idx }
                    }
                }
            };
            return GetRequest(request);
        }


        public JObject GetSceneInfoJson()
        {
            var request = new JObject
            {
                ["cmd"] = "get_scene_mode",
                ["get_scene_mode"] = new JObject
                {
                    ["chnn"] = m_chnn,
                    ["idx"] = m_idx
                }
            };

            return GetRequest(request);
        }


        public ImageBoolSettings CollectImageBoolSettings()
        {
            ImageBoolSettings settings = new ImageBoolSettings();
            settings.Flip = m_cameraInfo.Flip;
            settings.Mirror = m_cameraInfo.Mirror;
            settings.Cac = m_cameraInfo.Cac;
            settings.Flick = m_cameraInfo.PowerlineFrequency;
            settings.Monochrome = m_cameraInfo.Monochrome;
            settings.SharpnessEnhancement = m_cameraInfo.SharpnessEnhancement;
            return settings;
        }

        public ImageValueSettings CollectImageValueSettings()
        {
            ImageValueSettings settings = new ImageValueSettings();
            settings.Contrast = m_cameraInfo.Contrast.Cur;
            settings.Saturation = m_cameraInfo.Saturation.Cur;
            settings.Hue = m_cameraInfo.Hue.Cur;
            settings.Sharpness = m_cameraInfo.Sharpness.Cur;
            settings.Gamma = m_cameraInfo.Gamma.Cur;
            settings.Drc = m_cameraInfo.Drc.Cur;
            settings.ContrastEnhancement = m_cameraInfo.ContrastEnhancement.Cur;
            return settings;
        }

        public bool SetRequest(JObject requestJson)
        {
            string request = requestJson.ToString(Formatting.None);
            int ret = SLcamNet.l_sdk_request(m_id, request, out IntPtr resultStr);

            if (resultStr == IntPtr.Zero)
            {
                SLcamNet.NetCamera.LOG("Set request failed");
                return false;
            }

            string result = Marshal.PtrToStringAnsi(resultStr);
            SLcamNet.l_sdk_free(resultStr);

            JObject resJson = JObject.Parse(result);
            int code = resJson[requestJson["cmd"].ToString()]["code"].ToObject<int>();

            return ret == 0 && code == 0;
        }
    }
}