import ctypes
import filecmp
import logging
import os
import platform
import shutil
import sys
import time
# 第三方库，用于视频显示
os.environ['PYGAME_HIDE_SUPPORT_PROMPT'] = '1'
import pygame

import slncam

def copy_files(source_folders, dest_folder):
    os.makedirs(dest_folder, exist_ok=True)

    for sources_folder in source_folders:
        for root, dirs, files in os.walk(sources_folder):
            for file in files:
                source_path = os.path.join(root, file)
                relative_path = os.path.relpath(root, sources_folder)

                if relative_path == '.':
                    relative_path = ''

                dest_dir = os.path.join(dest_folder, relative_path)
                os.makedirs(dest_dir, exist_ok=True)

                dest_path = os.path.join(dest_dir, file)

                if not os.path.exists(dest_path) or not filecmp.cmp(source_path, dest_path, shallow=False):
                    try:
                        shutil.copy2(source_path, dest_path)
                        # print(f'Copy succeed {source_path} -> {dest_path}')
                    except Exception as e:
                        print(f'Copy failed {source_path}: {e}')

def load_dll_path():
    script_dir = os.path.dirname(os.path.abspath(__file__))
    arch = platform.architecture()[0]
    arch_dir = 'x64' if '64' in arch else 'x86'

    if sys.platform == 'win32':
        platform_dir = 'win'
        dll_dir = 'bin'

    sdk_path = os.path.abspath(os.path.join(script_dir, '../../sdk', platform_dir, 'slncam', dll_dir, arch_dir))
    ffmpeg_path = os.path.abspath(os.path.join(script_dir, '../../sdk', platform_dir, 'FFmpeg', dll_dir, arch_dir))
    run_path = os.path.abspath(os.path.join(script_dir, 'build', arch_dir))
    copy_files([sdk_path, ffmpeg_path], run_path)
    return run_path

if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    # 拷贝依赖库至指定路径并加载
    dll_path = load_dll_path()
    slncam.NetDLL.set_load_dll_path(dll_path)
    slncam.NetCamera.init_net()
    time.sleep(1)

    while True:
        net_infos = slncam.NetCamera.search_available_cameras()
        for i, net_info in enumerate(net_infos):
            print('相机%d, IP=%s, 型号=%s, 版本=%d' % (i + 1, net_info.ip, net_info.model, net_info.version))
        select = int(input('请选择相机, 0重新搜索可用相机, -1退出选择\n'))
        if select == 0:
            continue
        else:
            break

    select = select - 1
    if select < 0 or select >= len(net_infos):
        print('相机选择错误, 退出程序')
        slncam.NetCamera.destroy_net()
        exit(0)

    net_info = net_infos[select]
    net_info.username = 'admin'
    net_info.password = '123456'
    settings = slncam.CameraStreamSettings(net_info)

    camera = slncam.NetCamera.create(net_info.model, net_info.version)
    camera.set_stream_settings(settings)
    camera.login()
    camera_info = camera.get_net_camera_all_info()
    capabilities = camera_info.video_stream_capabilities
    for i, ability in enumerate(capabilities):
        print('视频流能力%d, 格式=%d, 分辨率=%s, 帧率=%d' %
              (i + 1, ability.format, ability.resolution.size, ability.fps))

    select_ability = int(input('请选择需打开的视频流能力编号:\n')) - 1
    if select_ability < 0 or select_ability >= len(capabilities):
        print('视频流能力选择错误, 退出程序')
        camera.logout()
        slncam.NetCamera.destroy_net()
        exit(0)

    settings = slncam.CameraStreamSettings(net_info, capabilities[select_ability].resolution,
                                     capabilities[select_ability].format, slncam.SLNCAM_PIX_FORMAT_RGB888,
                                     'cbr', 'high', capabilities[select_ability].fps, 86000, 120)
    camera.set_stream_settings(settings)
    camera.open_stream()

    # For test
    # net_info = slncam.NetInfo('192.168.3.222', 'C314_IPC', username='admin', password='123456', port=80)
    # settings = slncam.CameraStreamSettings(net_info, slncam.SLNcamResolution(1920, 1080), pix_format=slncam.SLNCAM_PIX_FORMAT_RGB888, rc_mode='cbr', quality='high', frame_rate= 30, bitrate=86000, key_frame_interval=120)
    # camera = slncam.NetCamera.create(net_info.model)
    # camera.set_stream_settings(settings)
    # camera.login()
    # camera_info = camera.get_net_camera_all_info()
    # camera.open_stream()

    # 图片流暂不使用
    # pic_settings = slncam.CameraPicStreamSettings(capabilities[select_ability].resolution,
    #                                               slncam.SLNCAM_PIC_STREAM_FORMAT_JPEG, 'high', 333)
    # camera.set_pic_stream_settings(pic_settings)
    # camera.request_pic_stream()

    pygame.init()
    flags = pygame.SHOWN | pygame.RESIZABLE
    screen_w = 960
    screen_h = 540
    screen = pygame.display.set_mode((screen_w, screen_h), flags)
    pygame.display.set_caption('Net SDK Demo')
    pygame.key.stop_text_input()
    clock = pygame.time.Clock()
    running = True

    capture_frame = False
    save_file_index = 0
    get_frame_failed_count = 0
    while running:
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                # 返回键退出程序
                if event.key == pygame.K_ESCAPE:
                    running = False
                # 按A拍照
                elif event.key == pygame.K_a:
                    capture_frame = True
                elif event.key == pygame.K_b:
                    camera.set_flip(True)
                elif event.key == pygame.K_c:
                    camera.set_flip(False)
                # elif event.key == pygame.K_d:
                #     # 通过图片流保存图片
                #     camera.save_pic('img1.jpg')
                elif event.key == pygame.K_e:
                    camera.upgrade('C:/Users/admin/Desktop/test/c314_update_v1.7.0.lpk')
                elif event.key == pygame.K_f:
                    status, percentage = camera.get_upgrade_status()
                    print('Upgrade status=%s, percentage=%d' % (status, percentage))
                elif event.key == pygame.K_g:
                    # 设置相机有线IP地址
                    camera_info.ip_info.ip = '192.168.3.220'
                    camera.set_ipv4(camera_info.ip_info.dhcp, camera_info.ip_info.ip, camera_info.ip_info.gateway,
                                    camera_info.ip_info.netmask, camera_info.ip_info.dns1, camera_info.ip_info.dns1,
                                    camera_info.ip_info.mac)
                elif event.key == pygame.K_h:
                    # 切换视频流分辨率
                    settings.resolution = slncam.SLNcamResolution(4000, 3000)
                    camera.change_stream_settings(settings)
                elif event.key == pygame.K_i:
                    # 设置变倍
                    camera_info.zoom.cur = (camera_info.zoom.cur + 10) % camera_info.zoom.max
                    camera_info.dzoom.cur = 0
                    camera.setZoom(camera_info.zoom.cur, camera_info.dzoom.cur,
                                   camera_info.zoom_speed.cur, slncam.SLNCAM_ZOOM_MODE_ABSOLUTE)
                elif event.key == pygame.K_j:
                    # 一键聚焦
                    camera_info.focus.mode = slncam.SLNCAM_FOCUS_MODE_ONCE
                    camera.set_focus(camera_info.focus.mode, camera_info.focus.value.cur, camera_info.focus.speed.cur)
                elif event.key == pygame.K_k:
                    # 自动曝光示例
                    camera_info.exposure.mode = slncam.SLNCAM_EXPOSURE_MODE_AUTO
                    camera_info.exposure.bright.cur = (camera_info.exposure.bright.cur + 15) % camera_info.exposure.bright.max
                    camera.set_exposure(camera_info.exposure.mode, camera_info.exposure.bright.cur,
                                        camera_info.exposure.gain.cur, camera_info.exposure.time.cur)
                elif event.key == pygame.K_l:
                    # 手动曝光示例
                    camera_info.exposure.mode = slncam.SLNCAM_EXPOSURE_MODE_MANUAL
                    camera_info.exposure.gain.cur = (camera_info.exposure.gain.cur + 3) % camera_info.exposure.gain.max
                    camera_info.exposure.time.cur = (camera_info.exposure.time.cur + 15) % camera_info.exposure.time.max
                    camera.set_exposure(camera_info.exposure.mode, camera_info.exposure.bright.cur,
                                        camera_info.exposure.gain.cur, camera_info.exposure.time.cur)
                elif event.key == pygame.K_m:
                    # 自动白平衡示例
                    camera_info.white_balance.mode = slncam.SLNCAM_WB_MODE_AUTO
                    camera.set_wb(camera_info.white_balance.mode, camera_info.white_balance.red.cur,
                                  camera_info.white_balance.green.cur, camera_info.white_balance.blue.cur)
                elif event.key == pygame.K_n:
                    # 不改变颜色状态, 切换至手动白平衡示例
                    camera_info.white_balance = camera.get_wb_info()
                    camera_info.white_balance.mode = slncam.SLNCAM_WB_MODE_MANUAL
                    camera.set_wb(camera_info.white_balance.mode, camera_info.white_balance.red.cur,
                                  camera_info.white_balance.green.cur, camera_info.white_balance.blue.cur)
                elif event.key == pygame.K_o:
                    # 手动白平衡示例
                    camera_info.white_balance.mode = slncam.SLNCAM_WB_MODE_MANUAL
                    camera_info.white_balance.red.cur = (camera_info.white_balance.red.cur + 100) % camera_info.white_balance.red.max
                    camera_info.white_balance.green.cur = (camera_info.white_balance.green.cur + 100) % camera_info.white_balance.green.max
                    camera_info.white_balance.blue.cur = (camera_info.white_balance.blue.cur + 100) % camera_info.white_balance.blue.max
                    camera.set_wb(camera_info.white_balance.mode, camera_info.white_balance.red.cur,
                                  camera_info.white_balance.green.cur, camera_info.white_balance.blue.cur)
                elif event.key == pygame.K_p:
                    # 设置无线IP相关信息, 仅在STA模式下生效(除Mac地址外)
                    camera_info.ip_info.wireless_dhcp = True
                    # camera_info.ip_info.wireless_dhcp = False
                    # camera_info.ip_info.wireless_ip = '192.168.30.222'
                    # camera_info.ip_info.wireless_gateway = '192.168.30.1'
                    # camera_info.ip_info.wireless_netmask = '255.255.255.0'
                    camera.set_wireless_ipv4(camera_info.ip_info.wireless_dhcp, camera_info.ip_info.wireless_ip,
                                             camera_info.ip_info.wireless_gateway, camera_info.ip_info.wireless_netmask,
                                             camera_info.ip_info.wireless_dns1, camera_info.ip_info.wireless_dns2,
                                             camera_info.ip_info.wireless_mac)
                elif event.key == pygame.K_q:
                    # 设置相机至AP模式
                    camera_info.ip_info.wireless_type = 'ap'
                    camera_info.ip_info.wireless_net = '5g'
                    camera_info.ip_info.wireless_ssid = camera_info.ip_info.wireless_ap_ssid = 'SL_WIFI_Camera1'
                    camera_info.ip_info.wireless_password = camera_info.ip_info.wireless_ap_password = '123456789'
                    camera_info.ip_info.wireless_encryption = 'wpa-wpa2 psk'
                    camera.set_wireless(camera_info.ip_info.wireless_type, camera_info.ip_info.wireless_type,
                                        camera_info.ip_info.wireless_ap_ssid, camera_info.ip_info.wireless_ap_password,
                                        camera_info.ip_info.wireless_sta_ssid, camera_info.ip_info.wireless_sta_password,
                                        camera_info.ip_info.wireless_encryption)
                elif event.key == pygame.K_r:
                    # 设置相机至STA模式
                    camera_info.ip_info.wireless_type = 'sta'
                    # 路由器WIFI频段, SSID及密码
                    camera_info.ip_info.wireless_net = '5g'
                    camera_info.ip_info.wireless_ssid = camera_info.ip_info.wireless_sta_ssid = 'HUAWEI_5G'
                    camera_info.ip_info.wireless_password = camera_info.ip_info.wireless_sta_password = 'SL123456'
                    camera_info.ip_info.wireless_encryption = 'wpa-wpa2 psk'
                    camera.set_wireless(camera_info.ip_info.wireless_type, camera_info.ip_info.wireless_type,
                                        camera_info.ip_info.wireless_ap_ssid, camera_info.ip_info.wireless_ap_password,
                                        camera_info.ip_info.wireless_sta_ssid, camera_info.ip_info.wireless_sta_password,
                                        camera_info.ip_info.wireless_encryption)
                elif event.key == pygame.K_s:
                    camera_info.contrast_enhancement.cur = (camera_info.contrast_enhancement.cur + 1) % camera_info.contrast_enhancement.max
                    camera.set_contrast_enhancement(camera_info.contrast_enhancement.cur)
                elif event.key == pygame.K_t:
                    camera_info.sharpness_enhancement = not camera_info.sharpness_enhancement
                    camera.set_sharpness_enhancement(camera_info.sharpness_enhancement)
                # elif ......
            elif event.type == pygame.QUIT:
                running = False
            elif event.type == pygame.WINDOWRESIZED:
                screen_w = event.x
                screen_h = event.y

        frame = camera.get_video_frame_data()
        if frame is None:
            get_frame_failed_count = get_frame_failed_count + 1
            if get_frame_failed_count > 300:
                print('Net camera disconnect!')
                running = False
        else:
            get_frame_failed_count = 0
            rgb_bytes = ctypes.string_at(frame.data.rgb_data.p_rgb,
                                         frame.data.rgb_data.pitch_888 * frame.resolution.h)
            img = pygame.image.frombytes(rgb_bytes, (frame.resolution.w, frame.resolution.h), 'RGB')
            if capture_frame:
                file_path = os.path.expanduser('~/Pictures/img%d.png' % (save_file_index))
                pygame.image.save(img, file_path)
                save_file_index = save_file_index + 1
                print('图片已保存至: %s' % (file_path))
                capture_frame = False
            img = pygame.transform.scale(img, (screen_w, screen_h))
            screen.blit(img, (0, 0))
            slncam.NetCamera.free_video_frame_data(frame)

        pygame.display.flip()
        clock.tick(100)  # limits FPS to 100

    pygame.quit()
    # camera.close_pic_stream()
    camera.close_stream()
    camera.logout()
    slncam.NetCamera.destroy_net()