﻿#include <stdio.h>
#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <iomanip>
#include <iostream>
#include <map>
#include <random>

#include "slcam.h"

using namespace std;

void my_sleep(int ms)
{
#ifdef _WIN32
    Sleep(ms);
#else
    usleep(ms * 1000);
#endif
}

void upgrade_callback(int percent, void *ctx)
{
    std::cout << "Percent=" << percent
              << ", ctx=" << *(reinterpret_cast<int *>(ctx)) << std::endl;
}

int32_t mode = 0, unit = 0;
int32_t version = 0;
int32_t value = 0, min_value = 0, max_value = 0, def_value = 0, step_value = 0;
int32_t min_x = 0, min_y = 0, max_x = 0, max_y = 0, def_x = 0, def_y = 0,
        step_x = 0, step_y = 0;
int32_t state = 0;
int32_t flag = 0;
int32_t enable = 0;
int32_t x = 0, y = 0, w = 0, h = 0, width = 0, height = 0;
int32_t user_id = 0;
int32_t speed = 0;
uint8_t unique_id[60] = {0};
int32_t read_len = 0;
char suffix = 0;

void test_focus_state(HSLcam cam)
{
    int32_t state = 0;
    int32_t value = 0;
    cout << "##### 设置聚焦模式为手动"
         << slcam_set_focus_mode(cam, SLCAM_FOCUS_MODE_MANUAL) << endl;
    slcam_set_focus(cam, 2);
    cout << "##### 设置手动聚焦值为2" << endl;
    cout << "##### 设置聚焦模式为自动"
         << slcam_set_focus_mode(cam, SLCAM_FOCUS_MODE_AUTO) << endl;
    /*  slcam_get_focus_state(cam, &state);
      cout << "##### 获取当前聚焦状态：" << (state == 0 ? "聚焦中" : "聚焦完成")
           << endl;*/

    int32_t count = 0;
    while (count++ < 15)
    {
        slcam_get_focus_state(cam, &state);
        cout << "##### 获取当前聚焦状态："
             << (state == 0 ? "聚焦中" : "聚焦完成") << endl;
        slcam_get_focus(cam, &value);
        cout << "##### 获取当前手动聚焦值" << value << endl;
        my_sleep(400);
    }
}
void test__auto_focus_range(HSLcam cam)
{
    int32_t mode = 0;
    int32_t min_value = 0, max_value = 0;
    cout << "##### 设置聚焦模式为自动"
         << slcam_set_focus_mode(cam, SLCAM_FOCUS_MODE_AUTO) << endl;
    slcam_get_focus_mode(cam, &mode);
    cout << "##### 获取当前聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    // 修改自动聚焦范围并验证是否成功
    slcam_get_auto_focus_range(cam, &min_value, &max_value);
    cout << "#### 获取当前聚焦范围：最大值：" << max_value << "最小值："
         << min_value << endl;
    cout << "#### 修改当前设备自动聚焦的最大值为60，最小值为30" << endl;
    slcam_set_auto_focus_range(cam, 30, 60);
    slcam_get_auto_focus_range(cam, &min_value, &max_value);
    cout << "#### 获取修改后聚焦范围：最大值：" << max_value << "最小值："
         << min_value << endl;
}
void test__uxxxx(HSLcam cam)
{
    if (slcam_get_unique_id(cam, unique_id, sizeof(unique_id), &read_len) ==
        SLCAMRET_SUCCESS)
    {
        std::cout << "slcam_get_unique_id, unique_id=";
        std::cout << std::showbase << std::hex;
        for (int i = 0; i < read_len; ++i)
        {
            std::cout << static_cast<int32_t>(unique_id[i]) << " ";
        }
        std::cout << std::resetiosflags(std::ios::basefield)
                  << ", read_len=" << read_len << std::endl;
    }
    cout << "##### 修改曝光模式为自动曝光：" << slcam_set_exposure_mode(cam, 1)
         << endl;
    slcam_get_exposure_mode(cam, &mode);
    cout << "##### 获取曝光模式为："
         << (mode == SLCAM_EXPOSURE_MODE_AUTO ? "自动" : "手动") << endl;
    // 设置曝光区域
    cout << "##### 设置当前曝光区域为（1，1，4，4）:"
         << slcam_set_auto_exposure_region(cam, 1, 1, 4, 4) << endl;
    slcam_get_auto_exposure_region(cam, &x, &y, &w, &h);
    cout << "x的坐标：" << x << ",y的坐标:" << y << ",宽:" << w << ",高：" << h
         << endl;

    cout << "##### 修改白平衡模式为自动白平衡："
         << slcam_set_white_balance_mode(cam, 1) << endl;
    slcam_get_white_balance_mode(cam, &mode);
    cout << "##### 获取白平衡模式为："
         << (mode == SLCAM_WHITE_BALANCE_MODE_AUTO ? "自动" : "手动") << endl;

    // 修改区域白平衡
    slcam_get_auto_whitebalance_region(cam, &x, &y, &w, &h);
    cout << "当前白平衡区域: x=" << x << ", y=" << y << ",w=" << w << ",h=" << h
         << endl;
    cout << "设置区域白平衡为x=100,y=100,w=200,h=200" << endl;
    slcam_set_auto_whitebalance_region(cam, 100, 100, 200, 200);
    slcam_get_auto_whitebalance_region(cam, &x, &y, &w, &h);
    cout << "设置后白平衡区域: x=" << x << ", y=" << y << ",w=" << w
         << ",h=" << h << endl;

    // 获取色温范围
    slcam_get_white_balance_temperature_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "色温最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改色温值并验证是否修改成功
    cout << "##### 修改色温值为3000："
         << slcam_set_white_balance_temperature(cam, 3000) << endl;
    slcam_get_white_balance_temperature(cam, &value);
    cout << "##### 获取色温值为：" << value << endl;
    slcam_set_white_balance_temperature(cam, def_value);

    slcam_set_exposure_gain_unit(cam, SLCAM_EXPOSURE_GAIN_MAGNIFICATION);
    slcam_get_exposure_gain_unit(cam, &unit);
    cout << "##### 获取曝光模式为："
         << (unit == SLCAM_EXPOSURE_GAIN_MAGNIFICATION ? "倍率" : "DB") << endl;
    slcam_set_exposure_gain_unit(cam, SLCAM_EXPOSURE_GAIN_DB);
    slcam_get_exposure_gain_unit(cam, &unit);
    cout << "##### 获取曝光模式为："
         << (unit == SLCAM_EXPOSURE_GAIN_MAGNIFICATION ? "倍率" : "DB") << endl;
    // 对比度增强（0关闭，1开启）
    cout << "##### 修改对比度增强为开启：" << slcam_set_ldci(cam, 1) << endl;
    slcam_get_ldci(cam, &enable);
    cout << "##### 获取对比度增强状态：" << (enable == 1 ? "开启" : "关闭")
         << endl;
    cout << "##### 修改消对比度增强为关闭：" << slcam_set_ldci(cam, 0) << endl;
    slcam_get_ldci(cam, &enable);
    cout << "##### 获取对比度增强状态为：" << (enable == 1 ? "开启" : "关闭")
         << endl;

    // 设置弱纹理增强
    cout << "##### 修改弱纹理增强状态为开启：" << slcam_set_bayer_shp(cam, 1)
         << endl;
    slcam_get_bayer_shp(cam, &enable);
    cout << "##### 获取弱纹理增强状态：" << (enable == 1 ? "开启" : "关闭")
         << endl;
    cout << "##### 修改弱纹理增强为关闭：" << slcam_set_bayer_shp(cam, 0)
         << endl;
    slcam_get_bayer_shp(cam, &enable);
    cout << "##### 获取弱纹理增强状态：" << (enable == 1 ? "开启" : "关闭")
         << endl;
    // 修改用户ID
    cout << "##### 修改用户ID为67108863：" << slcam_set_user_id(cam, 67108863)
         << endl;
    my_sleep(300);
    slcam_get_user_id(cam, &user_id);
    cout << "##### 获取修改后用户id：" << user_id << endl;
    cout << "##### 修改用户ID为0：" << slcam_set_user_id(cam, 0) << endl;
    my_sleep(1500);
    slcam_get_user_id(cam, &user_id);
    cout << "##### 获取此时用户ID：" << user_id << endl;
    // 修改配置模式并验证是否成功（0为默认模式，1为金相模式）
    cout << "##### 修改配置模式为金相模式：" << slcam_set_scene(cam, 1) << endl;
    slcam_get_scene(cam, &flag);
    cout << "##### 获取配置模式为：" << (flag == 1 ? "金相" : "默认") << endl;
    cout << "##### 修改配置模式为默认模式：" << slcam_set_scene(cam, 0) << endl;
    slcam_get_scene(cam, &flag);
    cout << "##### 获取配置模式为：" << (flag == 1 ? "金相" : "默认") << endl;
    // 修改长曝光并验证是否修改成功
    slcam_get_long_exposure_time_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "长曝光:最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;
    cout << "##### 修改长曝光时间为5：" << slcam_set_long_exposure_time(cam, 5)
         << endl;
    slcam_get_long_exposure_time(cam, &value);
    cout << "##### 获取当前长曝光时间为：" << value << endl;
    slcam_set_exposure_mode(cam, 0);

    //设置为贝塞尔曲线模式并验证
    slcam_set_gamma_mode(cam, SLCAM_GAMMA_MODE_BEZIER);
    slcam_get_gamma_mode(cam, &mode);
    cout << "Gamma Mode set to: "
         << (mode == SLCAM_GAMMA_MODE_BEZIER ? "常规" : "曲线")
         << endl;

    std::random_device rd;
    std::mt19937 gen(rd());
    map<int, int> bezier_map;
    const int num_points = 25;
    SLPoint bezier_points[num_points];
    std::uniform_int_distribution<> xUnf(0, 255);
    std::uniform_int_distribution<> yUnf(0, 255);

    // 往map里面添加直至数量到达25
    // map insert时会去重，并且按照大小排序
    while (bezier_map.size() < num_points)
    {
        int x = xUnf(gen);
        int y = yUnf(gen);
        auto it = bezier_map.insert({x, y});
    }

    int index = 0;
    // 把map中存放的x,y放回bezier_points中
   //  使用迭代器遍历map
    for (auto it = bezier_map.begin();
         it != bezier_map.end() && index < num_points; ++it)
    {
        bezier_points[index].x = it->first;
        bezier_points[index].y = it->second;

        cout << "Index= " << index
             << ", X=" << static_cast<int>(bezier_points[index].x)
             << ",Y= " << static_cast<int>(bezier_points[index].y) << endl;
        ++index;
    }

     //调用设置 Gamma 贝塞尔曲线的函数
    int32_t result =
        slcam_set_gamma_bezier_curve(cam, bezier_points, num_points);

    if (result == SLCAMRET_SUCCESS)
    {
        std::cout << "Gamma 贝塞尔曲线设置成功!" << std::endl;
    }
    else
    {
        std::cout << "设置 Gamma 贝塞尔曲线失败!" << std::endl;
    }

    SLPoint get_bezier_points[num_points];
    int get_num = 0;
    slcam_get_gamma_bezier_curve(cam, get_bezier_points, num_points, &get_num);
    for (int i = 0; i < num_points; ++i)
    {
        if (bezier_points[i].x != get_bezier_points[i].x ||
            bezier_points[i].y != get_bezier_points[i].y)
        {
            std::cout << "i =" << i << ", set x=" << bezier_points[i].x
                      << ", y=" << bezier_points[i].y
                      << ", get x=" << get_bezier_points[i].x
                      << ", y=" << get_bezier_points[i].y
                      << "设置和获取到的贝塞尔曲线不一致!" << std::endl;
        }
    }

    slcam_set_gamma_mode(cam, SLCAM_GAMMA_MODE_NORMAL); 
}
void test__Axxxx(HSLcam cam)
{
    const int32_t newLedVer = 120;
    int32_t version = 0;
    slcam_get_version(cam, &version);

    // 变倍速度
    slcam_set_zoom_speed(cam, 2);
    slcam_get_zoom_speed(cam, &speed);
    cout << "##### 当前获取变倍速度：" << speed << endl;
    slcam_set_zoom_speed(cam, 0);
    slcam_get_zoom_speed(cam, &speed);
    cout << "##### 当前获取变倍速度：" << speed << endl;

    // 灯的测试
    int32_t led_number = 0, part_number = 0, min_level = 0, max_level = 0,
            def_level = 0, step_level = 0;
    int32_t led_index = 0, part_index = 0, level = 0;
    int32_t up = 0, left = 0, right = 0, down = 0;
    slcam_get_led_info(
        cam, &led_number, &part_number, &min_level, &max_level, &def_level,
        &step_level);
    cout << "##### 获取该设备灯的信息: 灯的数量:" << led_number
         << "，灯的分区数量:" << part_number << "，最低亮度:" << min_level
         << ",最高亮度:" << max_level << ",默认亮度:" << def_level
         << ",亮度调节步长:" << step_level << endl;

    if (version < newLedVer)
    {
        cout << "#### 设置上分区灯的亮度为0" << slcam_set_led(cam, 0, 0, 0);
        slcam_get_led(cam, 0, 0, &level);
        cout << "##### 获取上分区灯数据：序号:" << led_index
             << "，分区:" << part_index << "，亮度:" << level << endl;

        // 测试之前灯接口
        cout << "##### 设置所有灯的亮度："
             << slcam_set_a3xx_all_led(cam, 44, 45, 46, 47) << endl;
        slcam_get_a3xx_all_led(cam, &up, &left, &right, &down);
        cout << "##### 获取所有灯的亮度：上分区灯的亮度：" << up
             << ",左分区灯的亮度:" << left << ",右分区的亮度:" << right
             << ",下分区的亮度:" << down << endl;
    }
    else
    {
        for (int i = 0; i < 4; i++)
        {
            // 关闭所有灯
            slcam_set_a3xx_led(cam, i, 0, 105);
            slcam_get_a3xx_led(cam, i, &enable, &level);
            cout << "slcam get_a3xx led,i=" << i << ", enable" << enable
                 << ", level：" << level << endl;
        }
        my_sleep(2000);
        for (int i = 0; i < 4; i++)
        {
            // 开启所有灯
            slcam_set_a3xx_led(cam, i, 1, 125);
            slcam_get_a3xx_led(cam, i, &enable, &level);
            cout << "slcam get_a3xx led,i=" << i << ", enable" << enable
                 << ", level：" << level << endl;
        }
    }
}
void test__MXXX__defog(HSLcam cam)
{
    // 除雾模式（0关闭，1开启，-1为设置失败）
    cout << "##### 修改除雾状态为开启：" << slcam_set_defog(cam, 1) << endl;
    slcam_get_defog(cam, &enable);
    cout << "##### 获取除雾状态：" << (enable == 1 ? "开启" : "关闭") << endl;
    cout << "##### 修改除雾状态为关闭：" << slcam_set_defog(cam, 0) << endl;
    slcam_get_defog(cam, &enable);
    cout << "##### 获取除雾状态：" << (enable == 1 ? "开启" : "关闭") << endl;
}
void test__M_C__focus(HSLcam cam)
{
    // 获取聚焦状态
    slcam_get_focus_mode(cam, &mode);
    cout << "##### 获取当前聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    // 设置聚焦状态并获取状态验证是否成功
    slcam_set_focus_mode(cam, SLCAM_FOCUS_MODE_AUTO);
    cout << "##### 获取设置后聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    slcam_get_focus_region_range(
        cam, &min_x, &min_y, &max_x, &max_y, &def_x, &def_y, &step_x, &step_y);
    cout << "##### 获取当前相机聚焦范围信息: "
         << "x最小值" << min_x << ", x最大值" << max_x << ", y最小值" << min_y
         << ", y最大值" << max_y << ", x的默认值" << def_x << ", y的默认值"
         << def_y << endl;
    cout << "#### 设置聚焦区域x=3，y=0" << endl;
    slcam_set_focus_region_v2(cam, 1, 0, 3, 0);
    slcam_get_focus_region_v2(cam, &enable, &mode, &x, &y);
    cout << "##### 获取当前相机聚焦区域: "
         << "enable=" << enable << ", mode=" << mode << ", x=" << x
         << ", y=" << y << endl;
    slcam_get_focus_mode(cam, &mode);
    cout << "##### 获取当前聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    slcam_get_focus_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "##### 获取当前相机聚焦信息: "
         << "最小值" << min_value << ",最大值" << max_value << ",默认值"
         << def_value << ",步长" << step_value << endl;
    slcam_get_focus_mode(cam, &mode);
    cout << "##### 获取当前聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    slcam_get_focus_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "##### 获取当前相机聚焦信息: "
         << "最小值" << min_value << ",最大值" << max_value << ",默认值"
         << def_value << ",步长" << step_value << endl;
}
void test__A__focus(HSLcam cam)
{
    // 获取聚焦状态
    slcam_get_focus_mode(cam, &mode);
    cout << "##### 获取当前聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    // 设置聚焦状态并获取状态验证是否成功
    slcam_set_focus_mode(cam, SLCAM_FOCUS_MODE_AUTO);
    cout << "##### 获取设置后聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    slcam_get_focus_region_range(
        cam, &min_x, &min_y, &max_x, &max_y, &def_x, &def_y, &step_x, &step_y);
    cout << "##### 获取当前相机聚焦范围信息: "
         << "x最小值" << min_x << ", x最大值" << max_x << ", y最小值" << min_y
         << ", y最大值" << max_y << ", x的默认值" << def_x << ", y的默认值"
         << def_y << endl;
    cout << "#### 设置聚焦区域起始坐标（1，1），聚焦框长宽（1919，1079）"
         << endl;
    slcam_set_focus_region_v3(cam, 1, 1, 1, 1919, 1079);
    slcam_get_focus_region_v3(cam, &enable, &x, &y, &width, &height);
    cout << "##### 获取当前相机聚焦位置: "
         << "聚焦是否开启enable=" << enable << ", 聚焦坐标 X=" << x
         << ", Y=" << y << ", 聚焦框大小width=" << width
         << ", height=" << height << endl;

    slcam_get_focus_mode(cam, &mode);
    cout << "##### 获取当前聚焦模式为: "
         << (mode == SLCAM_FOCUS_MODE_AUTO ? "自动" : "手动") << endl;
    slcam_get_focus_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "##### 获取当前相机聚焦信息: "
         << "最小值" << min_value << ",最大值" << max_value << ",默认值"
         << def_value << ",步长" << step_value << endl;
}
void test__zoom(HSLcam cam)
{
    // 获取zoom范围
    slcam_get_ozoom_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "光学变倍:最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值" << def_value << ",步长" << step_value << endl;

    slcam_get_dzoom_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "数字变倍:最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值" << def_value << ",步长" << step_value << endl;
    // 修改zoom并验证是否修改成功
    cout << "##### 修改zoom值为60：" << slcam_set_zoom(cam, 60) << endl;
    slcam_get_zoom(cam, &value);
    cout << "##### 获取当前zoom值为：" << value << endl;
}
void test_basics(HSLcam cam)
{
    // 修改曝光模式并验证是否成功(1为自动曝光，0为手动曝光)
    slcam_get_exposure_mode(cam, &mode);
    cout << "##### 获取当前曝光模式为: "
         << (mode == SLCAM_EXPOSURE_MODE_AUTO ? "自动" : "手动") << endl;
    cout << "##### 修改曝光模式为自动曝光：" << slcam_set_exposure_mode(cam, 1)
         << endl;
    slcam_get_exposure_mode(cam, &mode);
    cout << "##### 获取曝光模式为："
         << (mode == SLCAM_EXPOSURE_MODE_AUTO ? "自动" : "手动") << endl;

    // 修改抗屏闪模式并验证是否成功（0为60HZ，1为50HZ）
    cout << "##### 修改抗屏闪模式为50hz："
         << slcam_set_power_line_frequency(cam, 1) << endl;
    slcam_get_power_line_frequency(cam, &flag);
    cout << "##### 获取抗屏闪模式为：" << flag << endl;
    cout << "##### 修改抗屏闪模式为60hz："
         << slcam_set_power_line_frequency(cam, 0) << endl;
    slcam_get_power_line_frequency(cam, &flag);
    cout << "##### 获取抗屏闪模式为：" << flag << endl;

    // 同时修改镜像翻转并验证是否修改成功
    slcam_get_mirror(cam, &enable);
    cout << "##### 获取当前镜像状态为：" << enable << endl;
    slcam_get_flip(cam, &enable);
    cout << "##### 获取当前镜像状态为：" << enable << endl;
    cout << "##### 修改镜像翻转状态：" << slcam_set_mirror(cam, 1)
         << slcam_set_flip(cam, 1) << endl;
    slcam_get_mirror(cam, &enable);
    cout << "##### 获取当前镜像状态为：" << enable << endl;
    slcam_get_flip(cam, &enable);
    cout << "##### 获取当前镜像状态为：" << enable << endl;

    // 获取色度值范围
    slcam_get_hue_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "色度：最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值" << def_value << ",步长" << step_value << endl;
    // 修改色度值并验证是否修改成功
    cout << "##### 修改色度值为69：" << slcam_set_hue(cam, 69) << endl;
    slcam_get_hue(cam, &value);
    cout << "##### 获取当前色度值为：" << value << endl;
    slcam_set_hue(cam, def_value);

    // 获取锐度范围
    slcam_get_sharpness_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "锐度：最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值" << def_value << ",步长" << step_value << endl;
    // 修改锐度值并验证是否修改成功
    cout << "##### 修改锐度值为10：" << slcam_set_sharpness(cam, 10) << endl;
    slcam_get_sharpness(cam, &value);
    cout << "##### 获取当前锐度值为：" << value << endl;
    slcam_set_sharpness(cam, def_value);
    slcam_set_sharpness(cam, def_value);

    // 修改锐度增加模式并验证是否成功(0 禁用，1 启用)
    slcam_get_sharpness_enhancement(cam, &mode);
    cout << "##### 获取当前锐度增强: "
         << (mode == 0 ? "禁用" : "启用") << endl;
    cout << "##### 启用锐度增强：" << slcam_set_exposure_mode(cam, 1)
         << endl;
    slcam_get_exposure_mode(cam, &mode);
    cout << "##### 获取锐度增强模式为："
         << (mode == 0 ? "禁用" : "启用") << endl;

    // 获取饱和度范围
    slcam_get_saturation_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "饱和度：最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值" << def_value << ",步长" << step_value << endl;
    // 修改饱和度值并验证是否修改成功
    cout << "##### 修改饱和度值为60：" << slcam_set_saturation(cam, 60) << endl;
    slcam_get_saturation(cam, &value);
    cout << "##### 获取当前饱和度值为：" << value << endl;
    slcam_set_saturation(cam, def_value);

    // 获取对比度范围
    slcam_get_contrast_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "对比度：最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值" << def_value << ",步长" << step_value << endl;
    // 修改对比度值并验证是否修改成功
    cout << "##### 修改对比度值为60：" << slcam_set_contrast(cam, 60) << endl;
    slcam_get_contrast(cam, &value);
    cout << "##### 获取当前对比度值为：" << value << endl;
    slcam_set_contrast(cam, def_value);

    // 获取亮度值范围
    slcam_get_exposure_compensation_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "亮度:最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改亮度值并验证是否修改成功
    cout << "##### 修改亮度值为20：" << slcam_set_exposure_compensation(cam, 20)
         << endl;
    slcam_get_exposure_compensation(cam, &value);
    cout << "##### 获取当前亮度值为：" << value << endl;
    slcam_set_exposure_compensation(cam, def_value);
    cout << "##### 修改曝光模式为手动曝光：" << slcam_set_exposure_mode(cam, 0)
         << endl;
    slcam_get_exposure_mode(cam, &mode);
    cout << "##### 获取曝光模式为："
         << (mode == SLCAM_EXPOSURE_MODE_AUTO ? "自动" : "手动") << endl;

    // 获取快门值范围
    slcam_get_exposure_time_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "快门:最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;
    // 修改快门值并验证是否修改成功
    cout << "##### 修改快门值为最大："
         << slcam_set_exposure_time(cam, max_value) << endl;
    slcam_get_exposure_time(cam, &value);
    cout << "##### 获取当前快门值为：" << value << endl;

    // 获取增益值范围
    slcam_get_exposure_gain_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "增益最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改增益值并验证是否修改成功
    cout << "##### 修改增益值为20：" << slcam_set_exposure_gain(cam, 20)
         << endl;
    slcam_get_exposure_gain(cam, &value);
    cout << "##### 获取当前增益值为：" << value << endl;
    slcam_set_exposure_gain(cam, def_value);

    // 获取gamma范围
    slcam_get_gamma_range(cam, &min_value, &max_value, &def_value, &step_value);
    cout << "gamma最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改gamma值并验证是否修改成功
    cout << "##### 修改gamma值为1：" << slcam_set_gamma(cam, 1) << endl;
    slcam_get_gamma(cam, &value);
    cout << "##### 获取当前gamma值为：" << value << endl;
    slcam_set_gamma(cam, def_value);

    // 修改白平衡模式并验证是否成功（0为手动白平衡，1为自动白平衡）
    cout << "##### 修改白平衡模式为自动白平衡："
         << slcam_set_white_balance_mode(cam, 1) << endl;
    slcam_get_white_balance_mode(cam, &mode);
    cout << "##### 获取白平衡模式为："
         << (mode == SLCAM_WHITE_BALANCE_MODE_AUTO ? "自动" : "手动") << endl;

    cout << "##### 修改白平衡模式为手动白平衡："
         << slcam_set_white_balance_mode(cam, 0) << endl;
    slcam_get_white_balance_mode(cam, &mode);
    cout << "##### 获取白平衡模式为："
         << (mode == SLCAM_WHITE_BALANCE_MODE_AUTO ? "自动" : "手动") << endl;

    // 获取白平衡红的范围
    slcam_get_white_balance_component_red_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "白平衡红最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改白平衡红的值并验证是否修改成功
    cout << "##### 修改白平衡红值为200："
         << slcam_set_white_balance_component_red(cam, 200) << endl;
    slcam_get_white_balance_component_red(cam, &value);
    cout << "##### 获取白平衡红值为：" << value << endl;
    slcam_set_white_balance_component_red(cam, def_value);

    // 获取白平衡绿的范围
    slcam_get_white_balance_component_green_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "白平衡绿最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改白平衡绿的值并验证是否修改成功
    cout << "##### 修改白平衡绿值为200："
         << slcam_set_white_balance_component_green(cam, 200) << endl;
    slcam_get_white_balance_component_green(cam, &value);
    cout << "##### 获取白平衡绿值为：" << value << endl;
    slcam_set_white_balance_component_green(cam, def_value);

    // 获取白平衡蓝的范围
    slcam_get_white_balance_component_blue_range(
        cam, &min_value, &max_value, &def_value, &step_value);
    cout << "白平衡蓝最小值=" << min_value << ", 最大值=" << max_value
         << "，默认值=" << def_value << ",步长=" << step_value << endl;

    // 修改白平衡蓝的值并验证是否修改成功
    cout << "##### 修改白平衡蓝值为200："
         << slcam_set_white_balance_component_blue(cam, 200) << endl;
    slcam_get_white_balance_component_blue(cam, &value);
    cout << "##### 获取白平衡蓝值为：" << value << endl;
    slcam_set_white_balance_component_blue(cam, def_value);

    // 获取当前消反光的值
    slcam_get_drc(cam, &value);
    cout << "##### 当前消反光值为：" << value << endl;

    // 修改消反光并验证是否成功
    cout << "##### 修改消反光值为3：" << slcam_set_drc(cam, 3) << endl;
    slcam_get_drc(cam, &value);
    cout << "##### 获取消反光值为：" << value << endl;

    // 去紫边（0关闭，1开启）
    cout << "##### 修改去紫边为开启：" << slcam_set_cac(cam, 1) << endl;
    slcam_get_cac(cam, &enable);
    cout << "##### 获取去紫边状态为：" << (enable == 1 ? "开启" : "关闭")
         << endl;
    cout << "##### 修改去紫边为关闭：" << slcam_set_cac(cam, 0) << endl;
    slcam_get_cac(cam, &enable);
    cout << "##### 获取去紫边状态为：" << (enable == 1 ? "开启" : "关闭")
         << endl;
}

int main(int argc, char *argv[])
{
    slcam_api_init();
    slcam_log_set_level(SLCAM_LOG_INFO);
    // slcam_log_set_pattern("*** [%H:%M:%S %z] [thread %t] %v ***");
    // slcam_log_set_callback(log_callback);
    int select = 0;
    SLcamDevInfos enumInfo;
    while (true)
    {
        slcam_enum_devices(&enumInfo);
        std::cout << "##### 检测当前环境Camera设备" << std::endl;
        for (int i = 0; i < enumInfo.cameraNum; i++)
        {
            std::cout << "相机" << i + 1
                      << ": 名称=" << enumInfo.cameras[i].name;
            std::cout << ", UniqueName=" << enumInfo.cameras[i].uniqueName;
            std::cout << ", PID=" << std::hex << enumInfo.cameras[i].model;
            std::cout << std::resetiosflags(std::ios::basefield)
                      << ", USB速率=" << enumInfo.cameras[i].speed << std::endl;
        }
        std::cout << "##### 请选择相机, 0重新搜索可用相机, -1退出选择"
                  << std::endl;
        std::cin >> select;
        // std::cout << "select=" << select << std::endl;

        select = select - 1;

        if (select == (0 - 1))
            continue;

        break;
    }

    if (enumInfo.cameraNum == 0 || select < 0 || select >= enumInfo.cameraNum)
    {
        slcam_api_destroy();
        return 0;
    }

    HSLcam cam = nullptr;
    if (slcam_open(enumInfo.cameras[select].uniqueName, &cam) !=
        SLCAMRET_SUCCESS)
    {
        std::cout << "无法打开相机 " << enumInfo.cameras[select].uniqueName
                  << std::endl;
        slcam_api_destroy();
        system("pause");
        return -1;
    }
    cout << "##### 开始测试, 按回车继续" << endl;
    getchar();

    // 获取当前相机版本号
    slcam_get_version(cam, &version);
    cout << "版本号：" << version << endl;
    slcam_get_model_suffix(cam, &suffix);
    cout << "尾缀" << suffix << endl;
    int32_t value = 0, min_value = 0, max_value = 0, def_value = 0,
            step_value = 0, user_id = 0;

    // 修改用户ID
    //cout << "##### 修改用户ID为67108863：" << slcam_set_user_id(cam, 6710880)
    //     << endl;
    //my_sleep(1500);
    //slcam_get_user_id(cam, &user_id);
    //cout << "##### 获取修改后用户id：" << user_id << endl;
    //cout << "##### 修改用户ID为0：" << slcam_set_user_id(cam, 0) << endl;
    //my_sleep(1500);
    //slcam_get_user_id(cam, &user_id);
    //cout << "##### 获取此时用户ID：" << user_id << endl;
    // U408专用，修改设备名及升级
    //  int ctx = 124;
    //  slcam_upgrade(cam,
    //  "d:\\share\\DS-2K867(4K)V2001_240621.img",upgrade_callback, &ctx);
    //  slcam_set_device_name(cam, "NB_PLUS_1");

    //// 聚焦是否完成
    //test_focus_state(cam);
    //// 自动聚焦范围
    //test__auto_focus_range(cam);
    // 老聚焦接口测试
    //test__M_C__focus(cam);
    //test__zoom(cam);
    // //新设备聚焦接口
    //test__A__focus(cam);
    //test__Axxxx(cam);
    //test__MXXX__defog(cam); 
    test__uxxxx(cam);
    // test_basics(cam);
   

    slcam_close(cam);
    slcam_api_destroy();
    system("pause");
    return 0;
}
