QT       += core gui

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

CONFIG += c++11

# The following define makes your compiler emit warnings if you use
# any Qt feature that has been marked deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

# You can also make your code fail to compile if it uses deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0
TARGET = UvcQtDemo

win32 {
    DIR_SYSTEM = win
} else:mac {
    DIR_SYSTEM = mac
} else:unix {
    DIR_SYSTEM = linux
}

SOURCES += \
    main.cpp \
    mainwindow.cpp

HEADERS += \
    camerainfo.h \
    mainwindow.h

FORMS += \
    mainwindow.ui

include ($$PWD/video/video.pri)

INCLUDEPATH += $$PWD/../../../sdk/$${DIR_SYSTEM}/slcam/include

contains(QT_ARCH, i386) {
    DIR_PLATFORM = x86
} else {
    DIR_PLATFORM = x64
}

mac {
    DIR_PLATFORM =
}

win32-g++ {
    DIR_COMPILER = mingw
} else:win32-msvc* {
    DIR_COMPILER = msvc
    DEFINES += NOMINMAX
    QMAKE_CXXFLAGS += /utf-8
} else:linux-gcc {
    DIR_COMPILER = gcc
} else:macx-clang {
    DIR_COMPILER = mac_clang
}

LIBS += -L$$PWD/../../../sdk/$${DIR_SYSTEM}/slcam/lib/$${DIR_PLATFORM} -lslcam
LIBS += -L$$PWD/../../../sdk/$${DIR_SYSTEM}/FFmpeg/lib/$${DIR_PLATFORM} -lavcodec -lavdevice -lavformat -lavutil -lswscale

CONFIG(debug, debug|release) {
    DIR_CONFIG = debug
} else {
    DEFINES += NDEBUG
    DIR_CONFIG = release
}

DESTDIR = $$PWD/../build/$${DIR_COMPILER}/$${DIR_PLATFORM}/$${DIR_CONFIG}

OBJECTS_DIR = $$DESTDIR/../tmp/$${DIR_CONFIG}/obj
MOC_DIR = $$DESTDIR/../tmp/$${DIR_CONFIG}/moc
RCC_DIR = $$DESTDIR/../tmp/$${DIR_CONFIG}/qrc
UI_DIR = $$DESTDIR/../tmp/$${DIR_CONFIG}/ui

win32 {
    TARGET_FILE_PATH = $$DESTDIR/$(TARGET)
    TARGET_FILE_PATH = $$replace(TARGET_FILE_PATH, /, \\)

    TARGET_DIR = $$replace(DESTDIR, /, \\)

    SDK_FILE_PATHS = \
        $$PWD/../../../sdk/$${DIR_SYSTEM}/slcam/bin/$${DIR_PLATFORM} \
        $$PWD/../../../sdk/$${DIR_SYSTEM}/FFmpeg/bin/$${DIR_PLATFORM}

    for(path, SDK_FILE_PATHS) {
        path = $$replace(path, /, \\)
        QMAKE_POST_LINK += $$QMAKE_COPY \"$${path}\\*.dll\" \"$${TARGET_DIR}\" $$escape_expand(\\n)
    }

    QMAKE_POST_LINK += \"$$[QT_INSTALL_PREFIX]\\bin\\windeployqt.exe\" \"$${TARGET_FILE_PATH}\" $$escape_expand(\\n)

    CONFIG(release, debug|release) {
        BIN_DIR = $$PWD/../../bin/$${DIR_PLATFORM}
        BIN_DIR = $$replace(BIN_DIR, /, \\)
        QMAKE_POST_LINK += xcopy \"$${TARGET_DIR}\" \"$${BIN_DIR}\" /y /i /e
    }
}

# Default rules for deployment.
qnx: target.path = /tmp/$${TARGET}/bin
else: unix:!android: target.path = /opt/$${TARGET}/bin
!isEmpty(target.path): INSTALLS += target
