#ifndef CAMERA_INFO_H
#define CAMERA_INFO_H

#include "slcam.h"

struct CommonAttribute
{
    bool enable = false;
    int32_t cur;
    int32_t min;
    int32_t max;
    int32_t def;
    int32_t step;
    CommonAttribute() : enable(false), cur(-1), min(0), max(0), def(0), step(0)
    {
    }
};

struct ExposureInfo
{
    bool enable;
    SLcamExposureMode mode;
    CommonAttribute gain;
    CommonAttribute time;
    // 亮度
    CommonAttribute compensation;

    ExposureInfo() : enable(false), mode(SLCAM_EXPOSURE_MODE_AUTO) {}
};

struct WhiteBalanceInfo
{
    bool enable;
    SLcamWhiteBalanceMode mode;
    CommonAttribute red;
    CommonAttribute green;
    CommonAttribute blue;
    WhiteBalanceInfo() : enable(false), mode(SLCAM_WHITE_BALANCE_MODE_AUTO) {}
};

struct CameraInfo
{
    int32_t pid = 0;
    int32_t version = 0;
    ExposureInfo exposure;
    WhiteBalanceInfo whiteBalance;
};

#endif  // CAMERA_INFO_H
