#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMap>

#include "camerainfo.h"
#include "openglvideowidget.h"
#include "slcam.h"
#include "videothread.h"

namespace Ui
{
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

private:
    void openUVCCamera(const QString &friendlyName, const QString &uniqueName);
    void getCamInfo(CameraInfo &info, HSLcam cam);
    void updateCamUi(const CameraInfo &camInfo);
    void registerMetaTypes();
    void setWidgetsEnbaleStatus(bool cameraOpen);

private slots:
    void on_scan_btn_clicked();
    void on_openVideo_btn_clicked();
    void on_autoWB_btn_clicked();
    void on_manualWB_btn_clicked();
    void on_red_slider_valueChanged(int value);
    void on_green_slider_valueChanged(int value);
    void on_blue_slider_valueChanged(int value);
    void on_autoExp_btn_clicked();
    void on_manualExp_btn_clicked();
    void on_brightness_slider_valueChanged(int value);
    void on_gain_slider_valueChanged(int value);
    void on_shutter_slider_valueChanged(int value);
    void on_snap_btn_clicked();
    void on_video_tabWidget_tabCloseRequested(int index);
    void on_closeVideo_btn_clicked();

    void onGetSnapFrame(const VideoFrame &frame);

    void on_record_btn_toggled(bool checked);

signals:
    void getFrameForSnap();
    void startRecording(const QString &path);
    void stopRecording();

private:
    Ui::MainWindow *ui;
    QMap<QString, QString> m_cameraNames;
    QMap<QString, QString> m_connectingDevices;
    QScopedPointer<VideoThread> m_camCapThread;
    QScopedPointer<OpenGLVideoWidget> m_videoWidget;
    bool m_cameraOpend = false;
    CameraInfo m_camInfo;
    HSLcam m_currentCam = nullptr;

    bool m_sendMessageToCamera = false;
};
#endif  // MAINWINDOW_H
