#ifndef VIDEOTHREAD_H
#define VIDEOTHREAD_H

#include <QThread>

#include "slcam.h"
#include "videoframe.h"

class VideoThread : public QThread
{
    Q_OBJECT
public:
    VideoThread(HSLcam cam, QObject *parent = nullptr);
    void openVideoThread();
    void closeVideoThread();
    void setCapctx(const SLcamCaptureContext &capCtx);

protected:
    void run();

public slots:
    void onGetFrameForSnap();
    void onStartRecording(const QString &path);
    void onStopRecording();

signals:
    void sendFrameForDisplay(const VideoFrame &frame);
    void sendFrameForSnap(const VideoFrame &frame);
    void closeCamera();

private:
    HSLcam m_cam;
    bool m_isStarting;
    SLcamCaptureContext m_capCtx;
    bool m_needFrameForSnap;
    bool m_isRecording;
    QString m_recordFilePath;
};

#endif  // VIDEOTHREAD_H
