﻿using System;
using System.Runtime.InteropServices;

namespace csharpdemo
{
    public class SDL2
    {
        private const string libSDL = "SDL2.dll";

        [StructLayout(LayoutKind.Sequential)]
        public struct SDL_Rect
        {
            public int x, y;
            public int w, h;
        }

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern int SDL_Init(uint flags);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr SDL_CreateWindowFrom(IntPtr data);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr SDL_CreateRenderer(IntPtr window, int index, uint flags);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr SDL_CreateTexture(IntPtr renderer, uint format, int access, int w, int h);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern int SDL_UpdateYUVTexture(IntPtr texture, IntPtr rect, IntPtr yPlane, int yPitch,
            IntPtr uPlane, int uPitch, IntPtr vPlane, int vPitch);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern int SDL_RenderClear(IntPtr renderer);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern int SDL_RenderCopy(IntPtr renderer, IntPtr texture, IntPtr srcRect, IntPtr dstRect);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern void SDL_RenderPresent(IntPtr renderer);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern void SDL_DestroyTexture(IntPtr texture);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern void SDL_DestroyRenderer(IntPtr renderer);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern void SDL_DestroyWindow(IntPtr window);

        [DllImport(libSDL, CallingConvention = CallingConvention.Cdecl)]
        public static extern void SDL_Quit();

        public const uint SDL_INIT_VIDEO = 0x00000020;
        public const uint SDL_WINDOWPOS_UNDEFINED = 0x1FFF0000;
        public const uint SDL_TEXTUREACCESS_STREAMING = 1;
        public const uint SDL_PIXELFORMAT_IYUV = 1448433993;
        
        
    }
}