﻿using System;
using System.Diagnostics;
using System.Drawing;
using System.Threading.Tasks;
using System.Windows.Forms;
using csharpdemo;

namespace csharpdemo3
{
    public partial class Form1 : Form
    {
        private int _mCurrentCam = 0;
        private int _mCurrentCam2;
        private SLcam.SLcamDevInfo[] _devInfos;
        private SLcam _slcam;
        private SLcam _sLcam2;
        private SLcam.SLcamVideoCaptureCapabilities _capabilities;
        private SLcam.SLcamVideoCaptureCapabilities _capabilities2;
        private Task _task;
        private Task _task2;
        private volatile bool _running = true;
        private volatile bool _running2 = true;
        private SLcam.SLcamCaptureContext _captureContext;
        private SLcam.SLcamCaptureContext _captureContext2;
        private SDLPanel sdlPanel;
        private SDLPanel sdlPanel2;
        private volatile bool _isUpdateTexture = true;
        private readonly object updateTextureLock = new object();
        private readonly object updateTextureLock2 = new object();

        public Form1()
        {
            InitializeComponent();
            SLcam.slcam_api_init();
        }

        private void scan_btn_Click(object sender, EventArgs e)
        {
            // get device nums
            _devInfos = SLcam.EnumerateDevices();
            // 设置日志等级
            SLcam.LogSetLevel(SLcam.SLcamLogLevel.SLCAM_LOG_TRACE);
            // 日志回调函数 
            // RegisterLogCallback();
            if (_devInfos == null || _devInfos.Length <= 0) return;

            devList_cBox1.Items.Clear();
            devList_cBox2.Items.Clear();
            for (var i = 0; i < _devInfos.Length; i++)
            {
                devList_cBox1.Items.Add(_devInfos[i].name + i);
                devList_cBox2.Items.Add(_devInfos[i].name + i);
            }

            devList_cBox1.SelectedIndex = _mCurrentCam;
            devList_cBox2.SelectedIndex = _mCurrentCam2;
        }

        private void open_btn_Click(object sender, EventArgs e)
        {
            _slcam?.Dispose();
            sdlPanel = new SDLPanel();
            sdlPanel.Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;


            _slcam = SLcam.Open(_devInfos[_mCurrentCam].uniqueName);
            if (_slcam?.Handle == null)
            {
                MessageBox.Show("设备打开异常");
                return;
            }

            _slcam.GetCaptureCapabilities(out _capabilities);
            resolu_cBox.Items.Clear();
            for (var i = 0; i < _capabilities.nbCaps; i++)
            {
                var videoCap = _capabilities.videoCaps[i];
                if (videoCap.videoFmt == SLcam.SLcamVideoFormat.SLCAM_VIDEO_FORMAT_NV12)
                    resolu_cBox.Items.Add(videoCap.resolution.width + " * " +
                                          videoCap.resolution.height);
            }

            _captureContext = new SLcam.SLcamCaptureContext();
            // _captureContext.resolution = resolution;
            _captureContext.uniqueName = _devInfos[_mCurrentCam].uniqueName;
            // NV12 or MJPEG
            _captureContext.capFmt = SLcam.SLcamVideoFormat.SLCAM_VIDEO_FORMAT_NV12;
            _captureContext.readFmt = SLcam.SLcamPixFormat.SLCAM_PIX_FORMAT_I420;
            _captureContext.fps = _capabilities.videoCaps[0].maxFps;
            resolu_cBox.SelectedIndex = 0;
            _running = true;
            device_info();
            _task = Task.Run(() => StartCameraCapture(_devInfos, _mCurrentCam));

            Console.WriteLine("slcam = " + _slcam.Handle.ToString());
            Console.WriteLine("slcam = " + _slcam.Handle.GetHashCode());
        }

        private void device_info()
        {
            if (!_slcam.GetFocusRange(out int minValue, out int maxValue, out int defValue, out int stepValue))
            {
                autoFocus_checkBox.Enabled = false;
                minValue = maxValue = defValue = stepValue = 0;
            }
            else
            {
                if (_slcam.GetFocusMode(out int focusMode))
                {
                    if (focusMode == (int)SLcam.SLcamFocusMode.SLCAM_FOCUS_MODE_AUTO)
                    {
                        autoFocus_checkBox.Checked = true;
                    }
                    else if (focusMode == (int)SLcam.SLcamFocusMode.SLCAM_FOCUS_MODE_MANUAL)
                    {
                        autoFocus_checkBox.Checked = false;
                    }
                }
            }


            if (_slcam.GetWhiteBalanceMode(out int mode))
            {
                if (mode == (int)SLcam.SLcamWhiteBalanceMode.SLCAM_WHITE_BALANCE_MODE_MANUAL)
                {
                    autoWB_checkBoz.Checked = false;
                }
                else
                {
                    autoWB_checkBoz.Checked = true;
                }
            }

            if (_slcam.GetExposureMode(out mode))
            {
                if (mode == (int)SLcam.SLcamExposureMode.SLCAM_EXPOSURE_MODE_MANUAL)
                    autoExp_checkBox.Checked = false;

                else
                    autoExp_checkBox.Checked = true;
            }
        }

        private void StartCameraCapture(SLcam.SLcamDevInfo[] devInfos, int mCurrentCam)
        {
            var stopwatch = new Stopwatch();
            int frameCount = 0;
            stopwatch.Start();

            if (!_slcam.SetCaptureContext(ref _captureContext))
            {
                MessageBox.Show("Initialization Failed");
                return;
            }

            // 设置完参数后  需要等待一段时间后取流（否则可能会取流失败问题）
            // System.Threading.Thread.Sleep(500);

            var vframe = new SLcam.SLcamVideoFrame();
            while (_running)
            {
                if (!_slcam.ReadFrame(ref vframe)) continue;

                // 检查帧尺寸是否与期望的纹理尺寸匹配
                if (vframe.width != sdlPanel.VideoWidth || vframe.height != sdlPanel.VideoHeight)
                {
                    // 可以在这里调整vframe的数据尺寸，或者选择跳过该帧
                    continue;
                }

                frameCount++;

                if (stopwatch.ElapsedMilliseconds >= 3000)
                {
                    var fps = (double)(frameCount / (stopwatch.ElapsedMilliseconds / 1000.0));
                    Invoke((MethodInvoker)(() => { fps1_lab.Text = "fps1:" + fps.ToString("0.00"); }));

                    // 重置计时器和计数器
                    stopwatch.Restart();
                    frameCount = 0;
                }

                try
                {
                    lock (updateTextureLock)
                        this?.BeginInvoke((MethodInvoker)(() =>
                        {
                            sdlPanel.UpdateYUVTexture(vframe.data[0], vframe.data[1], vframe.data[2],
                                vframe.linesize[0], vframe.linesize[1], vframe.linesize[2], vframe.width,
                                vframe.height);
                        }));
                }
                catch (ObjectDisposedException)
                {
                    break;
                }

                System.Threading.Thread.Sleep(10);

                _slcam.FreeFrame(ref vframe);
            }
        }

        private void StartCameraCapture2(SLcam.SLcamDevInfo[] devInfos, int mCurrentCam)
        {
            var stopwatch = new Stopwatch();
            int frameCount = 0;
            stopwatch.Start();

            if (!_sLcam2.SetCaptureContext(ref _captureContext2))
            {
                MessageBox.Show("Initialization Failed");
                return;
            }

            // 设置完参数后  需要等待一段时间后取流（否则可能会取流失败问题）
            // System.Threading.Thread.Sleep(500);

            var vframe = new SLcam.SLcamVideoFrame();
            while (_running2)
            {
                if (!_sLcam2.ReadFrame(ref vframe)) continue;

                // 检查帧尺寸是否与期望的纹理尺寸匹配
                if (vframe.width != sdlPanel2.VideoWidth || vframe.height != sdlPanel2.VideoHeight)
                {
                    // 可以在这里调整vframe的数据尺寸，或者选择跳过该帧
                    continue;
                }

                frameCount++;

                if (stopwatch.ElapsedMilliseconds >= 3000)
                {
                    var fps = (double)(frameCount / (stopwatch.ElapsedMilliseconds / 1000.0));
                    Invoke((MethodInvoker)(() => { fps2_lab.Text = "fps2:" + fps.ToString("0.00"); }));

                    // 重置计时器和计数器
                    stopwatch.Restart();
                    frameCount = 0;
                }

                try
                {
                    lock (updateTextureLock2)
                        this?.BeginInvoke((MethodInvoker)(() =>
                        {
                            sdlPanel2.UpdateYUVTexture(vframe.data[0], vframe.data[1], vframe.data[2],
                                vframe.linesize[0], vframe.linesize[1], vframe.linesize[2], vframe.width,
                                vframe.height);
                        }));
                }
                catch (ObjectDisposedException)
                {
                    break;
                }

                System.Threading.Thread.Sleep(10);

                _sLcam2.FreeFrame(ref vframe);
            }
        }

        private void AdjustSDLPanelSize(Panel panel, SDLPanel sdlPanel)
        {
            // panel.AutoSizeMode = AutoSizeMode.GrowAndShrink;
            if (panel == null || sdlPanel == null || panel.Width == 0 || panel.Height == 0) return;

            // 原始SDLPanel的宽高比
            float aspectRatio = (float)sdlPanel.VideoWidth / sdlPanel.VideoHeight;

            int panelWidth = panel.Width;
            int panelHeight = panel.Height;

            int sdlPanelWidth, sdlPanelHeight;

            // 根据宽高比和父容器的大小计算新的大小，保持比例
            if (panelWidth / (float)panelHeight > aspectRatio)
            {
                // 限制在高度上
                sdlPanelHeight = panelHeight;
                sdlPanelWidth = (int)(sdlPanelHeight * aspectRatio);
            }
            else
            {
                // 限制在宽度上
                sdlPanelWidth = panelWidth;
                sdlPanelHeight = (int)(sdlPanelWidth / aspectRatio);
            }

            // 设置SDLPanel的新大小
            sdlPanel.Size = new Size(sdlPanelWidth, sdlPanelHeight);

            // 调整SDLPanel位置使其居中
            sdlPanel.Location =
                new Point((panel.Width - sdlPanel.Width) / 2 + 10, (panel.Height - sdlPanel.Height) / 2);
        }

        private void close_btn_Click(object sender, EventArgs e)
        {
            lock (updateTextureLock)
            {
                _running = false;
                _task = null;
                if (sdlPanel != null)
                {
                    this.panel1.Controls.Remove(sdlPanel);
                    // sdlPanel?.Dispose(true);
                    // sdlPanel = null;
                }

                if (_slcam != null)
                {
                    _slcam.Close();
                    _slcam = null;
                }
            }
        }

        private void devList_cBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            _mCurrentCam = devList_cBox1.SelectedIndex;
        }

        private SLcam.SLcamVideoResolution getResolution(string resolotionStr)
        {
            var strings = resolotionStr.Split('*');
            var resolution = new SLcam.SLcamVideoResolution();
            resolution.width = int.Parse(strings[0].Trim());
            resolution.height = int.Parse(strings[1].Trim());
            return resolution;
        }

        private void resolu_cBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            lock (updateTextureLock2)
            {
                _captureContext.resolution = getResolution(resolu_cBox.SelectedItem.ToString());
                _slcam.SetCaptureContext(ref _captureContext);
                // 接下来设置它的初始大小和位置
                int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
                int newHeight = ClientRectangle.Height - 8;
                panel1.Width = newWidth / 2;
                panel1.Height = newHeight;
                sdlPanel.Size = new Size(_captureContext.resolution.width, _captureContext.resolution.height);
                sdlPanel.Location = new Point(10, 10);
                // 将SDLPanel添加到MainForm的控件集合中
                this.panel1.Controls.Add(sdlPanel);
                sdlPanel.AdjustTextureSize(_captureContext.resolution.width, _captureContext.resolution.height);
                AdjustSDLPanelSize(panel1, sdlPanel);
            }
        }

        private void autoExp_checkBox_CheckedChanged(object sender, EventArgs e)
        {
            if (autoExp_checkBox.Checked)
                _slcam.SetExposureMode(SLcam.SLcamExposureMode.SLCAM_EXPOSURE_MODE_AUTO);
            else
                _slcam.SetExposureMode(SLcam.SLcamExposureMode.SLCAM_EXPOSURE_MODE_MANUAL);
        }

        private void autoWB_checkBoz_CheckedChanged(object sender, EventArgs e)
        {
            if (autoWB_checkBoz.Checked)
                _slcam.SetWhiteBalanceMode(SLcam.SLcamWhiteBalanceMode.SLCAM_WHITE_BALANCE_MODE_AUTO);
            else
            {
                _slcam.SetWhiteBalanceMode(SLcam.SLcamWhiteBalanceMode.SLCAM_WHITE_BALANCE_MODE_MANUAL);
            }
        }

        private void autoFocus_checkBox_CheckedChanged(object sender, EventArgs e)
        {
            if (autoFocus_checkBox.Checked)
                _slcam.SetFocusMode(SLcam.SLcamFocusMode.SLCAM_FOCUS_MODE_AUTO);
            else
            {
                _slcam.SetFocusMode(SLcam.SLcamFocusMode.SLCAM_FOCUS_MODE_MANUAL);
            }
        }


        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            _running = false;
            _running2 = false;
            _task = null;
            _task2 = null;
            if (sdlPanel != null)
            {
                sdlPanel?.Dispose(true);
                this.panel1.Controls.Remove(sdlPanel);
                sdlPanel = null;
            }

            if (sdlPanel2 != null)
            {
                sdlPanel2?.Dispose(true);
                this.panel2.Controls.Remove(sdlPanel2);
                sdlPanel2 = null;
            }

            if (_sLcam2 != null)
            {
                _sLcam2.Close();
                _sLcam2 = null;
            }

            SLcam.ApiDestroy();
        }

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            // _isUpdateTexture = false;

            int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
            int newHeight = ClientRectangle.Height - 8;
            lock (updateTextureLock)
            {
                panel1.Width = newWidth / 2;
                panel1.Height = newHeight;
                AdjustSDLPanelSize(panel1, sdlPanel);
            }

            lock (updateTextureLock2)
            {
                panel2.Width = newWidth / 2;
                panel2.Height = newHeight;
                panel2.Location = new Point(panel1.Bounds.Right, panel1.Location.Y);
                AdjustSDLPanelSize(panel2, sdlPanel2);
            }

            // _isUpdateTexture = true;
        }


        public static void MyLogCallbackFunction(int level, string msg)
        {
            Console.WriteLine($"Log Level: {level}, Message: {msg}");
        }

        public void RegisterLogCallback()
        {
            var callbackDelegate = new SLcam.SLcamLogCallback(MyLogCallbackFunction);
            SLcam.slcam_log_set_callback(callbackDelegate);
        }

        private void devList_cBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            _mCurrentCam2 = devList_cBox2.SelectedIndex;
        }

        private void open_btn2_Click(object sender, EventArgs e)
        {
            _sLcam2?.Dispose();
            sdlPanel2 = new SDLPanel();
            sdlPanel2.Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;


            _sLcam2 = SLcam.Open(_devInfos[_mCurrentCam2].uniqueName);
            if (_sLcam2?.Handle == null)
            {
                MessageBox.Show("设备打开异常");
                return;
            }

            _sLcam2.GetCaptureCapabilities(out _capabilities2);
            resolu_cBox2.Items.Clear();
            for (var i = 0; i < _capabilities2.nbCaps; i++)
            {
                var videoCap = _capabilities2.videoCaps[i];
                if (videoCap.videoFmt == SLcam.SLcamVideoFormat.SLCAM_VIDEO_FORMAT_NV12)
                    resolu_cBox2.Items.Add(videoCap.resolution.width + " * " +
                                           videoCap.resolution.height);
            }

            _captureContext2 = new SLcam.SLcamCaptureContext();
            // _captureContext.resolution = resolution;
            _captureContext2.uniqueName = _devInfos[_mCurrentCam2].uniqueName;
            // NV12 or MJPEG
            _captureContext2.capFmt = SLcam.SLcamVideoFormat.SLCAM_VIDEO_FORMAT_NV12;
            _captureContext2.readFmt = SLcam.SLcamPixFormat.SLCAM_PIX_FORMAT_I420;
            _captureContext2.fps = _capabilities2.videoCaps[0].maxFps;
            resolu_cBox2.SelectedIndex = 0;
            _running2 = true;
            // device_info();
            _task2 = Task.Run(() => StartCameraCapture2(_devInfos, _mCurrentCam));
        }

        private void close_btn2_Click(object sender, EventArgs e)
        {
            lock (updateTextureLock2)
            {
                _running2 = false;
                _task2 = null;
                if (sdlPanel2 != null)
                {
                    this.panel2.Controls.Remove(sdlPanel2);
                }

                if (_sLcam2 != null)
                {
                    _sLcam2.Close();
                    _sLcam2 = null;
                }
            }
        }

        private void resolu_cBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            lock (updateTextureLock2)
            {
                _captureContext2.resolution = getResolution(resolu_cBox2.SelectedItem.ToString());
                _sLcam2.SetCaptureContext(ref _captureContext2);
                // 接下来设置它的初始大小和位置
                int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
                int newHeight = ClientRectangle.Height - 8;
                panel2.Width = newWidth / 2;
                panel2.Height = newHeight;
                sdlPanel2.Size = new Size(_captureContext2.resolution.width, _captureContext2.resolution.height);
                sdlPanel2.Location = new Point(10, 10);
                // 将SDLPanel添加到MainForm的控件集合中
                this.panel2.Controls.Add(sdlPanel2);
                sdlPanel2.AdjustTextureSize(_captureContext2.resolution.width, _captureContext2.resolution.height);
                AdjustSDLPanelSize(panel2, sdlPanel2);
            }
        }

        // 设置Roi相关
        public void setRoi()
        {
            /*
             * x，y需为偶数，宽高需要为8的倍数 （YUV）
             * 裁剪后需要同步更改panel控件的大小，否则会造成画面卡死
             */
            // _slcam.SetRoiRegion(1, 8, 8, 1080, 1080);
            // int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
            // int newHeight = ClientRectangle.Height - 8;
            // panel1.Width = newWidth;
            // panel1.Height = newHeight;
            // sdlPanel.Size = new Size(1080, 1080);
            // sdlPanel.Location = new Point(10, 10);
            // // 将SDLPanel添加到MainForm的控件集合中
            // this.panel1.Controls.Add(sdlPanel);
            // sdlPanel.AdjustTextureSize(1080, 1080);
            // AdjustSDLPanelSize();

            // 复原，将enable设置为0（画面恢复为未裁剪之前，使用GetRoiRegion可获取之前设置过的大小 ）
            // _slcam.SetRoiRegion(0, 3, 5, 1080, 1080);
            // int newWidth = ClientRectangle.Right - scan_btn.Bounds.Right - 20;
            // int newHeight = ClientRectangle.Height - 8;
            // panel1.Width = newWidth;
            // panel1.Height = newHeight;
            // sdlPanel.Size = new Size(_captureContext.resolution.width, _captureContext.resolution.height);
            // sdlPanel.Location = new Point(10, 10);
            // // 将SDLPanel添加到MainForm的控件集合中
            // this.panel1.Controls.Add(sdlPanel);
            // sdlPanel.AdjustTextureSize(_captureContext.resolution.width, _captureContext.resolution.height);
            // AdjustSDLPanelSize();
        }
    }
}