﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace csharpdemo
{
    public class SDLPanel : UserControl
    {
        private IntPtr sdlWindow;
        private IntPtr sdlRenderer;
        private IntPtr sdlTexture;
        public int VideoWidth { get; private set; } = 640;
        public int VideoHeight { get; private set; } = 480;

        public SDLPanel()
        {
            if (SDL2.SDL_Init(SDL2.SDL_INIT_VIDEO) != 0)
            {
                throw new Exception("SDL could not initialize!");
            }
        }

        protected override void OnHandleCreated(EventArgs e)
        {
            base.OnHandleCreated(e);
            if (!DesignMode)
            {
                sdlWindow = SDL2.SDL_CreateWindowFrom(Handle);
                if (sdlWindow == IntPtr.Zero)
                {
                    throw new Exception("SDL window could not be created!");
                }

                sdlRenderer = SDL2.SDL_CreateRenderer(sdlWindow, -1, 0);
                if (sdlRenderer == IntPtr.Zero)
                {
                    throw new Exception("SDL renderer could not be created!");
                }

                // sdlTexture = SDL2.SDL_CreateTexture(sdlRenderer, SDL2.SDL_PIXELFORMAT_IYUV,
                //     (int)SDL2.SDL_TEXTUREACCESS_STREAMING, videoWidth, videoHeight);
                // if (sdlTexture == IntPtr.Zero)
                // {
                //     throw new Exception("SDL texture could not be created!");
                // }
            }
        }

        // 这个方法现在可以根据外部提供的宽度和高度来调整SDL纹理的大小
        public void AdjustTextureSize(int width, int height)
        {
            VideoWidth = width;
            VideoHeight = height;

            if (!DesignMode)
            {
                // 如果纹理已存在，则先销毁
                if (sdlTexture != IntPtr.Zero)
                {
                    SDL2.SDL_DestroyTexture(sdlTexture);
                }

                // 根据新的宽度和高度创建纹理
                sdlTexture = SDL2.SDL_CreateTexture(sdlRenderer, SDL2.SDL_PIXELFORMAT_IYUV,
                    (int)SDL2.SDL_TEXTUREACCESS_STREAMING, VideoWidth, VideoHeight);
                if (sdlTexture == IntPtr.Zero)
                {
                    throw new Exception("SDL texture could not be re-created!");
                }
            }
        }

        public void setRect(int width, int height)
        {
            SDL2.SDL_Rect dstrect = new SDL2.SDL_Rect();
            dstrect.x = 0;
            dstrect.y = 0;
            dstrect.w = width;
            dstrect.h = height;
        }

        public void UpdateYUVTexture(IntPtr yPlane, IntPtr uPlane, IntPtr vPlane, int yPitch, int uPitch, int vPitch,
            int width, int height)
        {
            if (width != VideoWidth || height != VideoHeight) return;
            if (sdlTexture != IntPtr.Zero)
            {
                if (width != VideoWidth || height != VideoHeight) return;
                // 直接使用IntPtr，无需通过GCHandle
                SDL2.SDL_UpdateYUVTexture(sdlTexture, IntPtr.Zero, yPlane, yPitch, uPlane, uPitch, vPlane, vPitch);
                SDL2.SDL_RenderClear(sdlRenderer);
                SDL2.SDL_RenderCopy(sdlRenderer, sdlTexture, IntPtr.Zero, IntPtr.Zero);
                SDL2.SDL_RenderPresent(sdlRenderer);
            }
        }

        public void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (sdlTexture != IntPtr.Zero)
                {
                    SDL2.SDL_DestroyTexture(sdlTexture);
                    sdlTexture = IntPtr.Zero;
                }

                if (sdlRenderer != IntPtr.Zero)
                {
                    SDL2.SDL_DestroyRenderer(sdlRenderer);
                    sdlRenderer = IntPtr.Zero;
                }

                if (sdlWindow != IntPtr.Zero)
                {
                    SDL2.SDL_DestroyWindow(sdlWindow);
                    sdlWindow = IntPtr.Zero;
                }

                SDL2.SDL_Quit();
            }

            // base.Dispose(disposing);
        }
    }
}