#ifndef ISLCAM_H_
#define ISLCAM_H_

#if defined(_WIN32)
#ifndef _INC_WINDOWS
#include <windows.h>
#endif
#endif

// {4D59932A-E53B-457D-9598-1386CEDDB374}
DEFINE_GUID(
    IID_ISLcam, 0x4d59932a, 0xe53b, 0x457d, 0x95, 0x98, 0x13, 0x86, 0xce, 0xdd,
    0xb3, 0x74);

DECLARE_INTERFACE_(ISLcam, IUnknown)
{
    /**
     * Get firmware version
     * C31xu/U1xx/M112u/M202u: real_version = double(version) / 100;
     * B201: real_version = double(version & 0xFFFF) / 100;
     */
    STDMETHOD(get_version)(int *version) PURE;
    STDMETHOD(get_model)(int *model) PURE;
    STDMETHOD(get_model_suffix)(char *suffix) PURE;
    /**
     *  Video Format
        UNKNOWN   -1 
        I420      0x0
        J420      0x1
        IYUV      0x2
        RGB24     0x3
        BGR24     0x4
        ABGR      0x5
        ARGB      0x6
        RGBA      0x7
        BGRA      0x8
        RGB565    0x9
        YUY2      0xa
        UYVY      0xb
        MJPEG     0xc
        H264      0xd
        H265      0xe
        NV12      0xf
     */
    STDMETHOD(get_capture_capabilitiy_number)(int *number) PURE;
    STDMETHOD(get_capture_capabilitiy)(unsigned index, int *width, int *height, int *video_format, int *fps) PURE;
    STDMETHOD(set_cap_ctx_index)(unsigned index) PURE;
    STDMETHOD(get_cap_ctx_index)(unsigned *index) PURE;
    STDMETHOD(set_cap_ctx)(int width, int height, int video_format, int fps) PURE;
    STDMETHOD(get_cap_ctx)(int *width, int *height, int *video_format, int *fps) PURE;

    /**
     * Set focus mode
     * @param mode  0 manual, 1 auto, 2 once/trigger once
     */
    STDMETHOD(set_focus_mode)(int mode) PURE;
    STDMETHOD(get_focus_mode)(int *mode) PURE;
    STDMETHOD(get_focus_mode_ex)(int *mode) PURE;

    STDMETHOD(set_focus)(int value) PURE;
    STDMETHOD(get_focus)(int *value) PURE;
    STDMETHOD(get_focus_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    /**
     * Increase/Decrease one focus value. Only for M Serise.
     */
    STDMETHOD(increase_focus)() PURE;
    STDMETHOD(decrease_focus)() PURE;

    /**
     * Set focus region, in auto focus mode(old version)
     * Support all focus camera
     * @param x     x pos
     * @param y     y pos
     */
    STDMETHOD(set_focus_region_v1)(int x, int y) PURE;
    /**
     * Get focus region(old version)
     * Support all focus camera
     */
    STDMETHOD(get_focus_region_v1)(int *x, int *y) PURE;

    /**
     * Set focus region, in auto focus mode
     * Support specific version camera
     * (c31x 1.4.0/A311u 1.0.0/m202u 1.2.0/m112u 1.1.1)
     * @param enable 0 disable, 1 enable
     * @param mode   0 small,   1 big
     *                 (small  0 <= x <= 16, 0 <= y <= 14)
     *                 (big    0 <= x <= 4,  0 <= y <= 4)
     * @param  x     x pos
     * @param  y     y pos
     */
    STDMETHOD(set_focus_region_v2)(int enable, int mode, int x, int y) PURE;

    /**
     * Get focus region
     * Support specific version camera
     * (c31x 1.4.0/A311u 1.0.0/m202u 1.2.0/m112u 1.1.1)
     */
    STDMETHOD(get_focus_region_v2)(int *enable, int *mode, int *x, int *y) PURE;

    /** Get focus region range
     *  Only get the range of small mode
     */
    STDMETHOD(get_focus_region_range)(int *min_x, int *min_y, int *max_x, int *max_y, int *def_x, int *def_y, int *step_x, int *step_y) PURE;

    /**
     * Set focus region, in auto focus mode
     * @param enable   0 disable, 1 enable
     * @param  x       x pos
     * @param  y       y pos
     * @param  width   width
     * @param  height  height
     */
    STDMETHOD(set_focus_region_v3)(int enable, int x, int y, int width, int height) PURE;

    /**
     * Get focus region
     */
    STDMETHOD(get_focus_region_v3)(int *enable, int *x, int *y, int *width, int *height) PURE;

    /**
     * Set power line frequence
     * @param flag  0 60hz, 1 50hz
     */
    STDMETHOD(set_power_line_frequency)(int flag) PURE;

    /**
     * Get power line frequence
     * @param flag  0 60hz, 1 50hz
     */
    STDMETHOD(get_power_line_frequency)(int *flag) PURE;

    /**
     * Set horizontal flip
     * @param enable  0 disable, 1 enable
     */
    STDMETHOD(set_mirror)(int enable) PURE;

    /**
     * Get horizontal flip
     * @param enable 0 disable, 1 enable
     */
    STDMETHOD(get_mirror)(int *enable) PURE;

    /**
     * Set vertical flip
     * @param enable  0 disable, 1 enable
     */
    STDMETHOD(set_flip)(int enable) PURE;

    /**
     * Get vertical flip
     * @param enable  0 disable, 1 enable
     */
    STDMETHOD(get_flip)(int *enable) PURE;

    STDMETHOD(set_hue)(int value) PURE;
    STDMETHOD(get_hue)(int *value) PURE;
    STDMETHOD(get_hue_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    STDMETHOD(set_sharpness)(int value) PURE;
    STDMETHOD(get_sharpness)(int *value) PURE;
    STDMETHOD(get_sharpness_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    STDMETHOD(set_saturation)(int value) PURE;
    STDMETHOD(get_saturation)(int *value) PURE;
    STDMETHOD(get_saturation_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    STDMETHOD(set_contrast)(int value) PURE;
    STDMETHOD(get_contrast)(int *value) PURE;
    STDMETHOD(get_contrast_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    /**
     * Set zoom and dzoom value, value range(zoom_min + dzoom_min, zoom_max +
     * dzoom_max) NOTICE: When value > zoom_max, enable dzoom, dzoom_value =
     * value - zoom_value dzoom: digital zoom
     */
    STDMETHOD(set_zoom)(int value) PURE;
    /**
     * Get zoom and dzoom value
     * When value > zoom_max, zoom_value = zoom_max, dzoom_value = value -
     * zoom_value When value <= zoom_max, zoom_value = value, dzoom_value = 0
     */
    STDMETHOD(get_zoom)(int *value) PURE;
    STDMETHOD(get_ozoom_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;
    STDMETHOD(get_dzoom_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    /**
     * Set zoom relative
     * @param zoom_rel      0 stop, 1 zoom out, -1 zoom in
     * @param digital_zoom  invaild
     * @param speed         invaild
     */
    STDMETHOD(set_zoom_relative)(signed char zoom_rel, unsigned char digital_zoom, unsigned char speed) PURE;
    STDMETHOD(get_zoom_relative)(signed char *zoom_rel, unsigned char *digital_zoom, unsigned char *speed) PURE;

    /**
     * Set zoom speed
     * @param speed  0 low, 1 medium, 2 high
     */
    STDMETHOD(set_zoom_speed)(int speed) PURE;
    /**
     * Get zoom speed
     * @param speed  0 low, 1 medium, 2 high
     */
    STDMETHOD(get_zoom_speed)(int *speed) PURE;

    /**
     * Set exposure mode
     * @param mode  0 manual, 1 auto
     */
    STDMETHOD(set_exposure_mode)(int mode) PURE;

    /**
     * Get exposure mode
     * @param mode  0 manual, 1 auto
     */
    STDMETHOD(get_exposure_mode)(int *mode) PURE;

    STDMETHOD(set_exposure_compensation)(int value) PURE;
    STDMETHOD(get_exposure_compensation)(int *value) PURE;
    STDMETHOD(get_exposure_compensation_range)(int *min_value, int *max_value, int *def_value, int *step_value) PURE;

    STDMETHOD(set_exposure_time)(int value) PURE;
    STDMETHOD(get_exposure_time)(int *value) PURE;
    STDMETHOD(get_exposure_time_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    STDMETHOD(set_long_exposure_time)(int value) PURE;
    STDMETHOD(get_long_exposure_time)(int *value) PURE;
    STDMETHOD(get_long_exposure_time_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    STDMETHOD(set_exposure_gain)(int value) PURE;
    STDMETHOD(get_exposure_gain)(int *value) PURE;
    STDMETHOD(get_exposure_gain_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    /**
     * Set gain unit
     * @param unit  0 magnification, 1 db
     */
    STDMETHOD(set_exposure_gain_unit)(int unit) PURE;

    /**
     * Get gain unit
     * @param unit  0 magnification, 1 db
     */
    STDMETHOD(get_exposure_gain_unit)(int *unit) PURE;

    STDMETHOD(set_gamma)(int value) PURE;
    STDMETHOD(get_gamma)(int *value) PURE;
    STDMETHOD(get_gamma_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    /**
     * Set white balance mode
     * @param mode  0 manual, 1 auto
     */
    STDMETHOD(set_white_balance_mode)(int mode) PURE;

    /**
     * Get white balance mode
     * @param mode  0 manual, 1 auto
     */
    STDMETHOD(get_white_balance_mode)(int *mode) PURE;

    STDMETHOD(set_white_balance_temperature)(int value) PURE;
    STDMETHOD(get_white_balance_temperature)(int *value) PURE;
    STDMETHOD(get_white_balance_temperature_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    STDMETHOD(set_white_balance_component_red)(int value) PURE;
    STDMETHOD(get_white_balance_component_red)(int *value) PURE;
    STDMETHOD(get_white_balance_component_red_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    STDMETHOD(set_white_balance_component_green)(int value) PURE;
    STDMETHOD(get_white_balance_component_green)(int *value) PURE;
    STDMETHOD(get_white_balance_component_green_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    STDMETHOD(set_white_balance_component_blue)(int value) PURE;
    STDMETHOD(get_white_balance_component_blue)(int *value) PURE;
    STDMETHOD(get_white_balance_component_blue_range)(int *min_value, int *max_value, int *def_value, int *step_value)PURE;

    STDMETHOD(set_auto_exposure_region)(int x, int y, int w, int h) PURE;
    STDMETHOD(get_auto_exposure_region)(int *x, int *y, int *w, int *h) PURE;

    STDMETHOD(set_auto_whitebalance_region)(int x, int y, int w, int h) PURE;
    STDMETHOD(get_auto_whitebalance_region)(int *x, int *y, int *w, int *h) PURE;

    /**
     * Change scene
     * @param flag  0 default scene, 1 metallography scene
     */
    STDMETHOD(set_scene)(int flag) PURE;
    STDMETHOD(get_scene)(int *flag) PURE;

    /**
     * Dynamic Range Compression
     * @param value range: 0-127
     */
    STDMETHOD(set_drc)(int value) PURE;
    STDMETHOD(get_drc)(int *value) PURE;

    /**
     * Chromatic Abberation Correction, for depurple
     * @param enable 0 disable, 1 enable
     */
    STDMETHOD(set_cac)(int enable) PURE;
    STDMETHOD(get_cac)(int *enable) PURE;

    /**
     * Local Dynamic Contrast Improvement
     * @param enable 0 disable, 1 enable
     */
    STDMETHOD(set_ldci)(int enable) PURE;
    STDMETHOD(get_ldci)(int *enable) PURE;

    /**
     * Weak Texture Enhancement
     * @param enable 0 disable, 1 enable
     */
    STDMETHOD(set_bayer_shp)(int enable) PURE;
    STDMETHOD(get_bayer_shp)(int *enable) PURE;

    /**
     * LED control
     * @param led_index  led index
     * @param part_index part index
     * @param level      led brightness
     */
    STDMETHOD(set_led)(int led_index, int part_index, int level) PURE;
    STDMETHOD(get_led)(int led_index, int part_index, int *level) PURE;
    STDMETHOD(get_led_info)(int *led_number, int *part_number, int *min_level, int *max_level, int *def_level, int *step_level)PURE;

    /**
     * A3XX LED control
     * @param up,left,right,down  brightness of the led postion
     * part_index for led pos: 0-up, 1-left, 2-right, 3-down
     */
    STDMETHOD(set_a3xx_all_led)(int up, int left, int right, int down) PURE;
    STDMETHOD(get_a3xx_all_led)(int *up, int *left, int *right, int *down) PURE;

    /**
     * A3XX LED control
     * @param part_index part index
     * @param enable     led enable state, 0-close, 1-open
     * @param level      led brightness
     */
    STDMETHOD(set_a3xx_led)(int part_index, int enable, int level) PURE;
    STDMETHOD(get_a3xx_led)(int part_index, int *enable, int *level) PURE;

    /**
     * Set defog mode, heat to prevent fogging up
     * @param enable  0 disable, 1 enable
     */
    STDMETHOD(set_defog)(int enable) PURE;

    /**
     * Get defog mode
     * @param enable  0 disable, 1 enable
     */
    STDMETHOD(get_defog)(int *enable) PURE;

    /**
     * Set user id
     * @param userID  range(0x0-0x3FFFFFF)
     */
    STDMETHOD(set_user_id)(int user_id) PURE;

    /**
     * Get user id
     */
    STDMETHOD(get_user_id)(int *user_id) PURE;
};

#endif  // ISLCAM_H_